/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.ChatCitation;
import com.cohere.api.types.ChatSearchQuery;
import com.cohere.api.types.ChatSearchResult;
import com.cohere.api.types.FinishReason;
import com.cohere.api.types.Message;
import com.cohere.api.types.ToolCall;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class NonStreamedChatResponse {
    private final String text;
    private final Optional<String> generationId;
    private final Optional<String> responseId;
    private final Optional<List<ChatCitation>> citations;
    private final Optional<List<Map<String, String>>> documents;
    private final Optional<Boolean> isSearchRequired;
    private final Optional<List<ChatSearchQuery>> searchQueries;
    private final Optional<List<ChatSearchResult>> searchResults;
    private final Optional<FinishReason> finishReason;
    private final Optional<List<ToolCall>> toolCalls;
    private final Optional<List<Message>> chatHistory;
    private final Optional<ApiMeta> meta;
    private final Map<String, Object> additionalProperties;

    private NonStreamedChatResponse(String text, Optional<String> generationId, Optional<String> responseId, Optional<List<ChatCitation>> citations, Optional<List<Map<String, String>>> documents, Optional<Boolean> isSearchRequired, Optional<List<ChatSearchQuery>> searchQueries, Optional<List<ChatSearchResult>> searchResults, Optional<FinishReason> finishReason, Optional<List<ToolCall>> toolCalls, Optional<List<Message>> chatHistory, Optional<ApiMeta> meta, Map<String, Object> additionalProperties) {
        this.text = text;
        this.generationId = generationId;
        this.responseId = responseId;
        this.citations = citations;
        this.documents = documents;
        this.isSearchRequired = isSearchRequired;
        this.searchQueries = searchQueries;
        this.searchResults = searchResults;
        this.finishReason = finishReason;
        this.toolCalls = toolCalls;
        this.chatHistory = chatHistory;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="generation_id")
    public Optional<String> getGenerationId() {
        return this.generationId;
    }

    @JsonProperty(value="response_id")
    public Optional<String> getResponseId() {
        return this.responseId;
    }

    @JsonProperty(value="citations")
    public Optional<List<ChatCitation>> getCitations() {
        return this.citations;
    }

    @JsonProperty(value="documents")
    public Optional<List<Map<String, String>>> getDocuments() {
        return this.documents;
    }

    @JsonProperty(value="is_search_required")
    public Optional<Boolean> getIsSearchRequired() {
        return this.isSearchRequired;
    }

    @JsonProperty(value="search_queries")
    public Optional<List<ChatSearchQuery>> getSearchQueries() {
        return this.searchQueries;
    }

    @JsonProperty(value="search_results")
    public Optional<List<ChatSearchResult>> getSearchResults() {
        return this.searchResults;
    }

    @JsonProperty(value="finish_reason")
    public Optional<FinishReason> getFinishReason() {
        return this.finishReason;
    }

    @JsonProperty(value="tool_calls")
    public Optional<List<ToolCall>> getToolCalls() {
        return this.toolCalls;
    }

    @JsonProperty(value="chat_history")
    public Optional<List<Message>> getChatHistory() {
        return this.chatHistory;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof NonStreamedChatResponse && this.equalTo((NonStreamedChatResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(NonStreamedChatResponse other) {
        return this.text.equals(other.text) && this.generationId.equals(other.generationId) && this.responseId.equals(other.responseId) && this.citations.equals(other.citations) && this.documents.equals(other.documents) && this.isSearchRequired.equals(other.isSearchRequired) && this.searchQueries.equals(other.searchQueries) && this.searchResults.equals(other.searchResults) && this.finishReason.equals(other.finishReason) && this.toolCalls.equals(other.toolCalls) && this.chatHistory.equals(other.chatHistory) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.generationId, this.responseId, this.citations, this.documents, this.isSearchRequired, this.searchQueries, this.searchResults, this.finishReason, this.toolCalls, this.chatHistory, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TextStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TextStage,
    _FinalStage {
        private String text;
        private Optional<ApiMeta> meta = Optional.empty();
        private Optional<List<Message>> chatHistory = Optional.empty();
        private Optional<List<ToolCall>> toolCalls = Optional.empty();
        private Optional<FinishReason> finishReason = Optional.empty();
        private Optional<List<ChatSearchResult>> searchResults = Optional.empty();
        private Optional<List<ChatSearchQuery>> searchQueries = Optional.empty();
        private Optional<Boolean> isSearchRequired = Optional.empty();
        private Optional<List<Map<String, String>>> documents = Optional.empty();
        private Optional<List<ChatCitation>> citations = Optional.empty();
        private Optional<String> responseId = Optional.empty();
        private Optional<String> generationId = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(NonStreamedChatResponse other) {
            this.text(other.getText());
            this.generationId(other.getGenerationId());
            this.responseId(other.getResponseId());
            this.citations(other.getCitations());
            this.documents(other.getDocuments());
            this.isSearchRequired(other.getIsSearchRequired());
            this.searchQueries(other.getSearchQueries());
            this.searchResults(other.getSearchResults());
            this.finishReason(other.getFinishReason());
            this.toolCalls(other.getToolCalls());
            this.chatHistory(other.getChatHistory());
            this.meta(other.getMeta());
            return this;
        }

        @Override
        @JsonSetter(value="text")
        public _FinalStage text(@NotNull String text) {
            this.text = Objects.requireNonNull(text, "text must not be null");
            return this;
        }

        @Override
        public _FinalStage meta(ApiMeta meta) {
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        @Override
        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public _FinalStage meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        @Override
        public _FinalStage chatHistory(List<Message> chatHistory) {
            this.chatHistory = Optional.ofNullable(chatHistory);
            return this;
        }

        @Override
        @JsonSetter(value="chat_history", nulls=Nulls.SKIP)
        public _FinalStage chatHistory(Optional<List<Message>> chatHistory) {
            this.chatHistory = chatHistory;
            return this;
        }

        @Override
        public _FinalStage toolCalls(List<ToolCall> toolCalls) {
            this.toolCalls = Optional.ofNullable(toolCalls);
            return this;
        }

        @Override
        @JsonSetter(value="tool_calls", nulls=Nulls.SKIP)
        public _FinalStage toolCalls(Optional<List<ToolCall>> toolCalls) {
            this.toolCalls = toolCalls;
            return this;
        }

        @Override
        public _FinalStage finishReason(FinishReason finishReason) {
            this.finishReason = Optional.ofNullable(finishReason);
            return this;
        }

        @Override
        @JsonSetter(value="finish_reason", nulls=Nulls.SKIP)
        public _FinalStage finishReason(Optional<FinishReason> finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        @Override
        public _FinalStage searchResults(List<ChatSearchResult> searchResults) {
            this.searchResults = Optional.ofNullable(searchResults);
            return this;
        }

        @Override
        @JsonSetter(value="search_results", nulls=Nulls.SKIP)
        public _FinalStage searchResults(Optional<List<ChatSearchResult>> searchResults) {
            this.searchResults = searchResults;
            return this;
        }

        @Override
        public _FinalStage searchQueries(List<ChatSearchQuery> searchQueries) {
            this.searchQueries = Optional.ofNullable(searchQueries);
            return this;
        }

        @Override
        @JsonSetter(value="search_queries", nulls=Nulls.SKIP)
        public _FinalStage searchQueries(Optional<List<ChatSearchQuery>> searchQueries) {
            this.searchQueries = searchQueries;
            return this;
        }

        @Override
        public _FinalStage isSearchRequired(Boolean isSearchRequired) {
            this.isSearchRequired = Optional.ofNullable(isSearchRequired);
            return this;
        }

        @Override
        @JsonSetter(value="is_search_required", nulls=Nulls.SKIP)
        public _FinalStage isSearchRequired(Optional<Boolean> isSearchRequired) {
            this.isSearchRequired = isSearchRequired;
            return this;
        }

        @Override
        public _FinalStage documents(List<Map<String, String>> documents) {
            this.documents = Optional.ofNullable(documents);
            return this;
        }

        @Override
        @JsonSetter(value="documents", nulls=Nulls.SKIP)
        public _FinalStage documents(Optional<List<Map<String, String>>> documents) {
            this.documents = documents;
            return this;
        }

        @Override
        public _FinalStage citations(List<ChatCitation> citations) {
            this.citations = Optional.ofNullable(citations);
            return this;
        }

        @Override
        @JsonSetter(value="citations", nulls=Nulls.SKIP)
        public _FinalStage citations(Optional<List<ChatCitation>> citations) {
            this.citations = citations;
            return this;
        }

        @Override
        public _FinalStage responseId(String responseId) {
            this.responseId = Optional.ofNullable(responseId);
            return this;
        }

        @Override
        @JsonSetter(value="response_id", nulls=Nulls.SKIP)
        public _FinalStage responseId(Optional<String> responseId) {
            this.responseId = responseId;
            return this;
        }

        @Override
        public _FinalStage generationId(String generationId) {
            this.generationId = Optional.ofNullable(generationId);
            return this;
        }

        @Override
        @JsonSetter(value="generation_id", nulls=Nulls.SKIP)
        public _FinalStage generationId(Optional<String> generationId) {
            this.generationId = generationId;
            return this;
        }

        @Override
        public NonStreamedChatResponse build() {
            return new NonStreamedChatResponse(this.text, this.generationId, this.responseId, this.citations, this.documents, this.isSearchRequired, this.searchQueries, this.searchResults, this.finishReason, this.toolCalls, this.chatHistory, this.meta, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public NonStreamedChatResponse build();

        public _FinalStage generationId(Optional<String> var1);

        public _FinalStage generationId(String var1);

        public _FinalStage responseId(Optional<String> var1);

        public _FinalStage responseId(String var1);

        public _FinalStage citations(Optional<List<ChatCitation>> var1);

        public _FinalStage citations(List<ChatCitation> var1);

        public _FinalStage documents(Optional<List<Map<String, String>>> var1);

        public _FinalStage documents(List<Map<String, String>> var1);

        public _FinalStage isSearchRequired(Optional<Boolean> var1);

        public _FinalStage isSearchRequired(Boolean var1);

        public _FinalStage searchQueries(Optional<List<ChatSearchQuery>> var1);

        public _FinalStage searchQueries(List<ChatSearchQuery> var1);

        public _FinalStage searchResults(Optional<List<ChatSearchResult>> var1);

        public _FinalStage searchResults(List<ChatSearchResult> var1);

        public _FinalStage finishReason(Optional<FinishReason> var1);

        public _FinalStage finishReason(FinishReason var1);

        public _FinalStage toolCalls(Optional<List<ToolCall>> var1);

        public _FinalStage toolCalls(List<ToolCall> var1);

        public _FinalStage chatHistory(Optional<List<Message>> var1);

        public _FinalStage chatHistory(List<Message> var1);

        public _FinalStage meta(Optional<ApiMeta> var1);

        public _FinalStage meta(ApiMeta var1);
    }

    public static interface TextStage {
        public _FinalStage text(@NotNull String var1);

        public Builder from(NonStreamedChatResponse var1);
    }
}

