/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ApiMeta;
import com.cohere.api.types.RerankResponseResultsItem;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class RerankResponse {
    private final Optional<String> id;
    private final List<RerankResponseResultsItem> results;
    private final Optional<ApiMeta> meta;
    private final Map<String, Object> additionalProperties;

    private RerankResponse(Optional<String> id, List<RerankResponseResultsItem> results, Optional<ApiMeta> meta, Map<String, Object> additionalProperties) {
        this.id = id;
        this.results = results;
        this.meta = meta;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return this.id;
    }

    @JsonProperty(value="results")
    public List<RerankResponseResultsItem> getResults() {
        return this.results;
    }

    @JsonProperty(value="meta")
    public Optional<ApiMeta> getMeta() {
        return this.meta;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof RerankResponse && this.equalTo((RerankResponse)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(RerankResponse other) {
        return this.id.equals(other.id) && this.results.equals(other.results) && this.meta.equals(other.meta);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.results, this.meta);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<String> id = Optional.empty();
        private List<RerankResponseResultsItem> results = new ArrayList<RerankResponseResultsItem>();
        private Optional<ApiMeta> meta = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(RerankResponse other) {
            this.id(other.getId());
            this.results(other.getResults());
            this.meta(other.getMeta());
            return this;
        }

        @JsonSetter(value="id", nulls=Nulls.SKIP)
        public Builder id(Optional<String> id) {
            this.id = id;
            return this;
        }

        public Builder id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @JsonSetter(value="results", nulls=Nulls.SKIP)
        public Builder results(List<RerankResponseResultsItem> results) {
            this.results.clear();
            this.results.addAll(results);
            return this;
        }

        public Builder addResults(RerankResponseResultsItem results) {
            this.results.add(results);
            return this;
        }

        public Builder addAllResults(List<RerankResponseResultsItem> results) {
            this.results.addAll(results);
            return this;
        }

        @JsonSetter(value="meta", nulls=Nulls.SKIP)
        public Builder meta(Optional<ApiMeta> meta) {
            this.meta = meta;
            return this;
        }

        public Builder meta(ApiMeta meta) {
            this.meta = Optional.ofNullable(meta);
            return this;
        }

        public RerankResponse build() {
            return new RerankResponse(this.id, this.results, this.meta, this.additionalProperties);
        }
    }
}

