/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class SingleGenerationTokenLikelihoodsItem {
    private final String token;
    private final double likelihood;
    private final Map<String, Object> additionalProperties;

    private SingleGenerationTokenLikelihoodsItem(String token, double likelihood, Map<String, Object> additionalProperties) {
        this.token = token;
        this.likelihood = likelihood;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="token")
    public String getToken() {
        return this.token;
    }

    @JsonProperty(value="likelihood")
    public double getLikelihood() {
        return this.likelihood;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof SingleGenerationTokenLikelihoodsItem && this.equalTo((SingleGenerationTokenLikelihoodsItem)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SingleGenerationTokenLikelihoodsItem other) {
        return this.token.equals(other.token) && this.likelihood == other.likelihood;
    }

    public int hashCode() {
        return Objects.hash(this.token, this.likelihood);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TokenStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TokenStage,
    LikelihoodStage,
    _FinalStage {
        private String token;
        private double likelihood;
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(SingleGenerationTokenLikelihoodsItem other) {
            this.token(other.getToken());
            this.likelihood(other.getLikelihood());
            return this;
        }

        @Override
        @JsonSetter(value="token")
        public LikelihoodStage token(@NotNull String token) {
            this.token = Objects.requireNonNull(token, "token must not be null");
            return this;
        }

        @Override
        @JsonSetter(value="likelihood")
        public _FinalStage likelihood(double likelihood) {
            this.likelihood = likelihood;
            return this;
        }

        @Override
        public SingleGenerationTokenLikelihoodsItem build() {
            return new SingleGenerationTokenLikelihoodsItem(this.token, this.likelihood, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public SingleGenerationTokenLikelihoodsItem build();
    }

    public static interface LikelihoodStage {
        public _FinalStage likelihood(double var1);
    }

    public static interface TokenStage {
        public LikelihoodStage token(@NotNull String var1);

        public Builder from(SingleGenerationTokenLikelihoodsItem var1);
    }
}

