/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.ChatDocumentSource;
import com.cohere.api.types.ChatToolSource;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class Source {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private Source(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static Source tool(ChatToolSource value) {
        return new Source(new ToolValue(value));
    }

    public static Source document(ChatDocumentSource value) {
        return new Source(new DocumentValue(value));
    }

    public boolean isTool() {
        return this.value instanceof ToolValue;
    }

    public boolean isDocument() {
        return this.value instanceof DocumentValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ChatToolSource> getTool() {
        if (this.isTool()) {
            return Optional.of(((ToolValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatDocumentSource> getDocument() {
        if (this.isDocument()) {
            return Optional.of(((DocumentValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "Source{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="document")
    @JsonIgnoreProperties(value={"type"})
    private static final class DocumentValue
    implements Value {
        @JsonUnwrapped
        private ChatDocumentSource value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DocumentValue() {
        }

        private DocumentValue(ChatDocumentSource value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDocument(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DocumentValue && this.equalTo((DocumentValue)other);
        }

        private boolean equalTo(DocumentValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Source{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool")
    @JsonIgnoreProperties(value={"type"})
    private static final class ToolValue
    implements Value {
        @JsonUnwrapped
        private ChatToolSource value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolValue() {
        }

        private ToolValue(ChatToolSource value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTool(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolValue && this.equalTo((ToolValue)other);
        }

        private boolean equalTo(ToolValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "Source{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=ToolValue.class), @JsonSubTypes.Type(value=DocumentValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitTool(ChatToolSource var1);

        public T visitDocument(ChatDocumentSource var1);

        public T _visitUnknown(Object var1);
    }
}

