/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.types.ChatCitationGenerationEvent;
import com.cohere.api.types.ChatDebugEvent;
import com.cohere.api.types.ChatSearchQueriesGenerationEvent;
import com.cohere.api.types.ChatSearchResultsEvent;
import com.cohere.api.types.ChatStreamEndEvent;
import com.cohere.api.types.ChatStreamStartEvent;
import com.cohere.api.types.ChatTextGenerationEvent;
import com.cohere.api.types.ChatToolCallsChunkEvent;
import com.cohere.api.types.ChatToolCallsGenerationEvent;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import java.util.Optional;

public final class StreamedChatResponse {
    private final Value value;

    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    private StreamedChatResponse(Value value) {
        this.value = value;
    }

    public <T> T visit(Visitor<T> visitor) {
        return this.value.visit(visitor);
    }

    public static StreamedChatResponse streamStart(ChatStreamStartEvent value) {
        return new StreamedChatResponse(new StreamStartValue(value));
    }

    public static StreamedChatResponse searchQueriesGeneration(ChatSearchQueriesGenerationEvent value) {
        return new StreamedChatResponse(new SearchQueriesGenerationValue(value));
    }

    public static StreamedChatResponse searchResults(ChatSearchResultsEvent value) {
        return new StreamedChatResponse(new SearchResultsValue(value));
    }

    public static StreamedChatResponse textGeneration(ChatTextGenerationEvent value) {
        return new StreamedChatResponse(new TextGenerationValue(value));
    }

    public static StreamedChatResponse citationGeneration(ChatCitationGenerationEvent value) {
        return new StreamedChatResponse(new CitationGenerationValue(value));
    }

    public static StreamedChatResponse toolCallsGeneration(ChatToolCallsGenerationEvent value) {
        return new StreamedChatResponse(new ToolCallsGenerationValue(value));
    }

    public static StreamedChatResponse streamEnd(ChatStreamEndEvent value) {
        return new StreamedChatResponse(new StreamEndValue(value));
    }

    public static StreamedChatResponse toolCallsChunk(ChatToolCallsChunkEvent value) {
        return new StreamedChatResponse(new ToolCallsChunkValue(value));
    }

    public static StreamedChatResponse debug(ChatDebugEvent value) {
        return new StreamedChatResponse(new DebugValue(value));
    }

    public boolean isStreamStart() {
        return this.value instanceof StreamStartValue;
    }

    public boolean isSearchQueriesGeneration() {
        return this.value instanceof SearchQueriesGenerationValue;
    }

    public boolean isSearchResults() {
        return this.value instanceof SearchResultsValue;
    }

    public boolean isTextGeneration() {
        return this.value instanceof TextGenerationValue;
    }

    public boolean isCitationGeneration() {
        return this.value instanceof CitationGenerationValue;
    }

    public boolean isToolCallsGeneration() {
        return this.value instanceof ToolCallsGenerationValue;
    }

    public boolean isStreamEnd() {
        return this.value instanceof StreamEndValue;
    }

    public boolean isToolCallsChunk() {
        return this.value instanceof ToolCallsChunkValue;
    }

    public boolean isDebug() {
        return this.value instanceof DebugValue;
    }

    public boolean _isUnknown() {
        return this.value instanceof _UnknownValue;
    }

    public Optional<ChatStreamStartEvent> getStreamStart() {
        if (this.isStreamStart()) {
            return Optional.of(((StreamStartValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatSearchQueriesGenerationEvent> getSearchQueriesGeneration() {
        if (this.isSearchQueriesGeneration()) {
            return Optional.of(((SearchQueriesGenerationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatSearchResultsEvent> getSearchResults() {
        if (this.isSearchResults()) {
            return Optional.of(((SearchResultsValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatTextGenerationEvent> getTextGeneration() {
        if (this.isTextGeneration()) {
            return Optional.of(((TextGenerationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatCitationGenerationEvent> getCitationGeneration() {
        if (this.isCitationGeneration()) {
            return Optional.of(((CitationGenerationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolCallsGenerationEvent> getToolCallsGeneration() {
        if (this.isToolCallsGeneration()) {
            return Optional.of(((ToolCallsGenerationValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatStreamEndEvent> getStreamEnd() {
        if (this.isStreamEnd()) {
            return Optional.of(((StreamEndValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatToolCallsChunkEvent> getToolCallsChunk() {
        if (this.isToolCallsChunk()) {
            return Optional.of(((ToolCallsChunkValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<ChatDebugEvent> getDebug() {
        if (this.isDebug()) {
            return Optional.of(((DebugValue)this.value).value);
        }
        return Optional.empty();
    }

    public Optional<Object> _getUnknown() {
        if (this._isUnknown()) {
            return Optional.of(((_UnknownValue)this.value).value);
        }
        return Optional.empty();
    }

    @JsonValue
    private Value getValue() {
        return this.value;
    }

    @JsonIgnoreProperties(value={"event_type"})
    private static final class _UnknownValue
    implements Value {
        private String type;
        @JsonValue
        private Object value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private _UnknownValue(@JsonProperty(value="value") Object value) {
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor._visitUnknown(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof _UnknownValue && this.equalTo((_UnknownValue)other);
        }

        private boolean equalTo(_UnknownValue other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public String toString() {
            return "StreamedChatResponse{type: " + this.type + ", value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="debug")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class DebugValue
    implements Value {
        @JsonUnwrapped
        private ChatDebugEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private DebugValue() {
        }

        private DebugValue(ChatDebugEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitDebug(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof DebugValue && this.equalTo((DebugValue)other);
        }

        private boolean equalTo(DebugValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-calls-chunk")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class ToolCallsChunkValue
    implements Value {
        @JsonUnwrapped
        private ChatToolCallsChunkEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolCallsChunkValue() {
        }

        private ToolCallsChunkValue(ChatToolCallsChunkEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolCallsChunk(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolCallsChunkValue && this.equalTo((ToolCallsChunkValue)other);
        }

        private boolean equalTo(ToolCallsChunkValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="stream-end")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class StreamEndValue
    implements Value {
        @JsonUnwrapped
        private ChatStreamEndEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StreamEndValue() {
        }

        private StreamEndValue(ChatStreamEndEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitStreamEnd(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof StreamEndValue && this.equalTo((StreamEndValue)other);
        }

        private boolean equalTo(StreamEndValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="tool-calls-generation")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class ToolCallsGenerationValue
    implements Value {
        @JsonUnwrapped
        private ChatToolCallsGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private ToolCallsGenerationValue() {
        }

        private ToolCallsGenerationValue(ChatToolCallsGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitToolCallsGeneration(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof ToolCallsGenerationValue && this.equalTo((ToolCallsGenerationValue)other);
        }

        private boolean equalTo(ToolCallsGenerationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="citation-generation")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class CitationGenerationValue
    implements Value {
        @JsonUnwrapped
        private ChatCitationGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private CitationGenerationValue() {
        }

        private CitationGenerationValue(ChatCitationGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitCitationGeneration(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof CitationGenerationValue && this.equalTo((CitationGenerationValue)other);
        }

        private boolean equalTo(CitationGenerationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="text-generation")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class TextGenerationValue
    implements Value {
        @JsonUnwrapped
        private ChatTextGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private TextGenerationValue() {
        }

        private TextGenerationValue(ChatTextGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitTextGeneration(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof TextGenerationValue && this.equalTo((TextGenerationValue)other);
        }

        private boolean equalTo(TextGenerationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="search-results")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class SearchResultsValue
    implements Value {
        @JsonUnwrapped
        private ChatSearchResultsEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SearchResultsValue() {
        }

        private SearchResultsValue(ChatSearchResultsEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSearchResults(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SearchResultsValue && this.equalTo((SearchResultsValue)other);
        }

        private boolean equalTo(SearchResultsValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="search-queries-generation")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class SearchQueriesGenerationValue
    implements Value {
        @JsonUnwrapped
        private ChatSearchQueriesGenerationEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private SearchQueriesGenerationValue() {
        }

        private SearchQueriesGenerationValue(ChatSearchQueriesGenerationEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitSearchQueriesGeneration(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof SearchQueriesGenerationValue && this.equalTo((SearchQueriesGenerationValue)other);
        }

        private boolean equalTo(SearchQueriesGenerationValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeName(value="stream-start")
    @JsonIgnoreProperties(value={"event_type"})
    private static final class StreamStartValue
    implements Value {
        @JsonUnwrapped
        private ChatStreamStartEvent value;

        @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
        private StreamStartValue() {
        }

        private StreamStartValue(ChatStreamStartEvent value) {
            this.value = value;
        }

        @Override
        public <T> T visit(Visitor<T> visitor) {
            return visitor.visitStreamStart(this.value);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            return other instanceof StreamStartValue && this.equalTo((StreamStartValue)other);
        }

        private boolean equalTo(StreamStartValue other) {
            return this.value.equals(other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return "StreamedChatResponse{value: " + this.value + "}";
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="event_type", visible=true, defaultImpl=_UnknownValue.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=StreamStartValue.class), @JsonSubTypes.Type(value=SearchQueriesGenerationValue.class), @JsonSubTypes.Type(value=SearchResultsValue.class), @JsonSubTypes.Type(value=TextGenerationValue.class), @JsonSubTypes.Type(value=CitationGenerationValue.class), @JsonSubTypes.Type(value=ToolCallsGenerationValue.class), @JsonSubTypes.Type(value=StreamEndValue.class), @JsonSubTypes.Type(value=ToolCallsChunkValue.class), @JsonSubTypes.Type(value=DebugValue.class)})
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static interface Value {
        public <T> T visit(Visitor<T> var1);
    }

    public static interface Visitor<T> {
        public T visitStreamStart(ChatStreamStartEvent var1);

        public T visitSearchQueriesGeneration(ChatSearchQueriesGenerationEvent var1);

        public T visitSearchResults(ChatSearchResultsEvent var1);

        public T visitTextGeneration(ChatTextGenerationEvent var1);

        public T visitCitationGeneration(ChatCitationGenerationEvent var1);

        public T visitToolCallsGeneration(ChatToolCallsGenerationEvent var1);

        public T visitStreamEnd(ChatStreamEndEvent var1);

        public T visitToolCallsChunk(ChatToolCallsChunkEvent var1);

        public T visitDebug(ChatDebugEvent var1);

        public T _visitUnknown(Object var1);
    }
}

