/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ThinkingType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Thinking {
    private final ThinkingType type;
    private final Optional<Integer> tokenBudget;
    private final Map<String, Object> additionalProperties;

    private Thinking(ThinkingType type, Optional<Integer> tokenBudget, Map<String, Object> additionalProperties) {
        this.type = type;
        this.tokenBudget = tokenBudget;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="type")
    public ThinkingType getType() {
        return this.type;
    }

    @JsonProperty(value="token_budget")
    public Optional<Integer> getTokenBudget() {
        return this.tokenBudget;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Thinking && this.equalTo((Thinking)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Thinking other) {
        return this.type.equals((Object)other.type) && this.tokenBudget.equals(other.tokenBudget);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.tokenBudget});
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static TypeStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements TypeStage,
    _FinalStage {
        private ThinkingType type;
        private Optional<Integer> tokenBudget = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(Thinking other) {
            this.type(other.getType());
            this.tokenBudget(other.getTokenBudget());
            return this;
        }

        @Override
        @JsonSetter(value="type")
        public _FinalStage type(@NotNull ThinkingType type) {
            this.type = Objects.requireNonNull(type, "type must not be null");
            return this;
        }

        @Override
        public _FinalStage tokenBudget(Integer tokenBudget) {
            this.tokenBudget = Optional.ofNullable(tokenBudget);
            return this;
        }

        @Override
        @JsonSetter(value="token_budget", nulls=Nulls.SKIP)
        public _FinalStage tokenBudget(Optional<Integer> tokenBudget) {
            this.tokenBudget = tokenBudget;
            return this;
        }

        @Override
        public Thinking build() {
            return new Thinking(this.type, this.tokenBudget, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public Thinking build();

        public _FinalStage tokenBudget(Optional<Integer> var1);

        public _FinalStage tokenBudget(Integer var1);
    }

    public static interface TypeStage {
        public _FinalStage type(@NotNull ThinkingType var1);

        public Builder from(Thinking var1);
    }
}

