/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.ToolCallV2Function;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class ToolCallV2 {
    private final String id;
    private final Optional<ToolCallV2Function> function;
    private final Map<String, Object> additionalProperties;

    private ToolCallV2(String id, Optional<ToolCallV2Function> function, Map<String, Object> additionalProperties) {
        this.id = id;
        this.function = function;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="type")
    public String getType() {
        return "function";
    }

    @JsonProperty(value="function")
    public Optional<ToolCallV2Function> getFunction() {
        return this.function;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof ToolCallV2 && this.equalTo((ToolCallV2)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ToolCallV2 other) {
        return this.id.equals(other.id) && this.function.equals(other.function);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.function);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder
    implements IdStage,
    _FinalStage {
        private String id;
        private Optional<ToolCallV2Function> function = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        @Override
        public Builder from(ToolCallV2 other) {
            this.id(other.getId());
            this.function(other.getFunction());
            return this;
        }

        @Override
        @JsonSetter(value="id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @Override
        public _FinalStage function(ToolCallV2Function function) {
            this.function = Optional.ofNullable(function);
            return this;
        }

        @Override
        @JsonSetter(value="function", nulls=Nulls.SKIP)
        public _FinalStage function(Optional<ToolCallV2Function> function) {
            this.function = function;
            return this;
        }

        @Override
        public ToolCallV2 build() {
            return new ToolCallV2(this.id, this.function, this.additionalProperties);
        }
    }

    public static interface _FinalStage {
        public ToolCallV2 build();

        public _FinalStage function(Optional<ToolCallV2Function> var1);

        public _FinalStage function(ToolCallV2Function var1);
    }

    public static interface IdStage {
        public _FinalStage id(@NotNull String var1);

        public Builder from(ToolCallV2 var1);
    }
}

