/*
 * Decompiled with CFR 0.152.
 */
package com.cohere.api.types;

import com.cohere.api.core.ObjectMappers;
import com.cohere.api.types.UsageBilledUnits;
import com.cohere.api.types.UsageTokens;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=Builder.class)
public final class Usage {
    private final Optional<UsageBilledUnits> billedUnits;
    private final Optional<UsageTokens> tokens;
    private final Optional<Double> cachedTokens;
    private final Map<String, Object> additionalProperties;

    private Usage(Optional<UsageBilledUnits> billedUnits, Optional<UsageTokens> tokens, Optional<Double> cachedTokens, Map<String, Object> additionalProperties) {
        this.billedUnits = billedUnits;
        this.tokens = tokens;
        this.cachedTokens = cachedTokens;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty(value="billed_units")
    public Optional<UsageBilledUnits> getBilledUnits() {
        return this.billedUnits;
    }

    @JsonProperty(value="tokens")
    public Optional<UsageTokens> getTokens() {
        return this.tokens;
    }

    @JsonProperty(value="cached_tokens")
    public Optional<Double> getCachedTokens() {
        return this.cachedTokens;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof Usage && this.equalTo((Usage)other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Usage other) {
        return this.billedUnits.equals(other.billedUnits) && this.tokens.equals(other.tokens) && this.cachedTokens.equals(other.cachedTokens);
    }

    public int hashCode() {
        return Objects.hash(this.billedUnits, this.tokens, this.cachedTokens);
    }

    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static final class Builder {
        private Optional<UsageBilledUnits> billedUnits = Optional.empty();
        private Optional<UsageTokens> tokens = Optional.empty();
        private Optional<Double> cachedTokens = Optional.empty();
        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<String, Object>();

        private Builder() {
        }

        public Builder from(Usage other) {
            this.billedUnits(other.getBilledUnits());
            this.tokens(other.getTokens());
            this.cachedTokens(other.getCachedTokens());
            return this;
        }

        @JsonSetter(value="billed_units", nulls=Nulls.SKIP)
        public Builder billedUnits(Optional<UsageBilledUnits> billedUnits) {
            this.billedUnits = billedUnits;
            return this;
        }

        public Builder billedUnits(UsageBilledUnits billedUnits) {
            this.billedUnits = Optional.ofNullable(billedUnits);
            return this;
        }

        @JsonSetter(value="tokens", nulls=Nulls.SKIP)
        public Builder tokens(Optional<UsageTokens> tokens) {
            this.tokens = tokens;
            return this;
        }

        public Builder tokens(UsageTokens tokens) {
            this.tokens = Optional.ofNullable(tokens);
            return this;
        }

        @JsonSetter(value="cached_tokens", nulls=Nulls.SKIP)
        public Builder cachedTokens(Optional<Double> cachedTokens) {
            this.cachedTokens = cachedTokens;
            return this;
        }

        public Builder cachedTokens(Double cachedTokens) {
            this.cachedTokens = Optional.ofNullable(cachedTokens);
            return this;
        }

        public Usage build() {
            return new Usage(this.billedUnits, this.tokens, this.cachedTokens, this.additionalProperties);
        }
    }
}

