/*
 * Decompiled with CFR 0.152.
 */
package com.coinbase.api;

import com.coinbase.api.entity.Account;
import com.coinbase.api.entity.AccountChangesResponse;
import com.coinbase.api.entity.AccountsResponse;
import com.coinbase.api.entity.Address;
import com.coinbase.api.entity.AddressResponse;
import com.coinbase.api.entity.AddressesResponse;
import com.coinbase.api.entity.Application;
import com.coinbase.api.entity.ApplicationsResponse;
import com.coinbase.api.entity.Button;
import com.coinbase.api.entity.ContactsResponse;
import com.coinbase.api.entity.HistoricalPrice;
import com.coinbase.api.entity.OAuthCodeRequest;
import com.coinbase.api.entity.OAuthTokensResponse;
import com.coinbase.api.entity.Order;
import com.coinbase.api.entity.OrdersResponse;
import com.coinbase.api.entity.PaymentMethodsResponse;
import com.coinbase.api.entity.Quote;
import com.coinbase.api.entity.RecurringPayment;
import com.coinbase.api.entity.RecurringPaymentsResponse;
import com.coinbase.api.entity.Report;
import com.coinbase.api.entity.ReportsResponse;
import com.coinbase.api.entity.Token;
import com.coinbase.api.entity.Transaction;
import com.coinbase.api.entity.TransactionsResponse;
import com.coinbase.api.entity.Transfer;
import com.coinbase.api.entity.TransfersResponse;
import com.coinbase.api.entity.User;
import com.coinbase.api.entity.UserResponse;
import com.coinbase.api.exception.CoinbaseException;
import com.coinbase.api.exception.CredentialsIncorrectException;
import com.coinbase.api.exception.TwoFactorIncorrectException;
import com.coinbase.api.exception.TwoFactorRequiredException;
import com.coinbase.api.exception.UnauthorizedDeviceException;
import com.coinbase.api.exception.UnspecifiedAccount;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public interface Coinbase {
    public User getUser() throws IOException, CoinbaseException;

    public Transaction getTransaction(String var1) throws IOException, CoinbaseException;

    public TransactionsResponse getTransactions() throws IOException, CoinbaseException;

    public TransactionsResponse getTransactions(int var1) throws IOException, CoinbaseException;

    public Transaction requestMoney(Transaction var1) throws CoinbaseException, IOException;

    public void resendRequest(String var1) throws CoinbaseException, IOException;

    public void deleteRequest(String var1) throws CoinbaseException, IOException;

    public Transaction completeRequest(String var1) throws CoinbaseException, IOException;

    public Transaction sendMoney(Transaction var1) throws CoinbaseException, IOException;

    public Order getOrder(String var1) throws IOException, CoinbaseException;

    public OrdersResponse getOrders() throws IOException, CoinbaseException;

    public OrdersResponse getOrders(int var1) throws IOException, CoinbaseException;

    public TransfersResponse getTransfers() throws IOException, CoinbaseException;

    public TransfersResponse getTransfers(int var1) throws IOException, CoinbaseException;

    public AddressesResponse getAddresses() throws IOException, CoinbaseException;

    public AddressesResponse getAddresses(int var1) throws IOException, CoinbaseException;

    public AccountsResponse getAccounts() throws IOException, CoinbaseException;

    public AccountsResponse getAccounts(int var1) throws IOException, CoinbaseException;

    public AccountsResponse getAccounts(int var1, int var2) throws IOException, CoinbaseException;

    public AccountsResponse getAccounts(int var1, int var2, boolean var3) throws IOException, CoinbaseException;

    public ContactsResponse getContacts() throws IOException, CoinbaseException;

    public ContactsResponse getContacts(int var1) throws IOException, CoinbaseException;

    public ContactsResponse getContacts(String var1) throws IOException, CoinbaseException;

    public ContactsResponse getContacts(String var1, int var2) throws IOException, CoinbaseException;

    public Money getBalance() throws UnspecifiedAccount, IOException, CoinbaseException;

    public Money getBalance(String var1) throws IOException, CoinbaseException;

    public void setPrimaryAccount() throws UnspecifiedAccount, CoinbaseException, IOException;

    public void setPrimaryAccount(String var1) throws CoinbaseException, IOException;

    public void deleteAccount() throws UnspecifiedAccount, CoinbaseException, IOException;

    public void deleteAccount(String var1) throws CoinbaseException, IOException;

    public void updateAccount(Account var1) throws UnspecifiedAccount, CoinbaseException, IOException;

    public void updateAccount(String var1, Account var2) throws CoinbaseException, IOException;

    public Account createAccount(Account var1) throws CoinbaseException, IOException;

    public Money getSpotPrice(CurrencyUnit var1) throws IOException, CoinbaseException;

    public Quote getBuyQuote(Money var1) throws IOException, CoinbaseException;

    public Quote getSellQuote(Money var1) throws IOException, CoinbaseException;

    public Button createButton(Button var1) throws CoinbaseException, IOException;

    public Order createOrder(Button var1) throws CoinbaseException, IOException;

    public Order createOrderForButton(String var1) throws CoinbaseException, IOException;

    public Transfer sell(Money var1) throws CoinbaseException, IOException;

    public Transfer sell(Money var1, String var2) throws CoinbaseException, IOException;

    public Transfer sell(Money var1, String var2, Boolean var3) throws CoinbaseException, IOException;

    public Transfer buy(Money var1) throws CoinbaseException, IOException;

    public Transfer buy(Money var1, String var2) throws CoinbaseException, IOException;

    public Transfer buy(Money var1, String var2, Boolean var3) throws CoinbaseException, IOException;

    public Transfer commitTransfer(String var1) throws CoinbaseException, IOException;

    public PaymentMethodsResponse getPaymentMethods() throws IOException, CoinbaseException;

    public RecurringPaymentsResponse getRecurringPayments() throws IOException, CoinbaseException;

    public RecurringPaymentsResponse getRecurringPayments(int var1) throws IOException, CoinbaseException;

    public RecurringPaymentsResponse getSubscribers() throws IOException, CoinbaseException;

    public RecurringPaymentsResponse getSubscribers(int var1) throws IOException, CoinbaseException;

    public Map<String, BigDecimal> getExchangeRates() throws IOException, CoinbaseException;

    public List<CurrencyUnit> getSupportedCurrencies() throws IOException, CoinbaseException;

    public User createUser(User var1) throws CoinbaseException, IOException;

    public User createUser(User var1, String var2, String var3) throws CoinbaseException, IOException;

    public UserResponse createUserWithOAuth(User var1, String var2, String var3) throws CoinbaseException, IOException;

    public User updateUser(String var1, User var2) throws CoinbaseException, IOException;

    public RecurringPayment getRecurringPayment(String var1) throws CoinbaseException, IOException;

    public RecurringPayment getSubscriber(String var1) throws CoinbaseException, IOException;

    public Token createToken() throws CoinbaseException, IOException;

    public void redeemToken(String var1) throws CoinbaseException, IOException;

    public AddressResponse generateReceiveAddress(Address var1) throws CoinbaseException, IOException;

    public AddressResponse generateReceiveAddress() throws CoinbaseException, IOException;

    public Application getApplication(String var1) throws CoinbaseException, IOException;

    public ApplicationsResponse getApplications() throws CoinbaseException, IOException;

    public Application createApplication(Application var1) throws CoinbaseException, IOException;

    public List<HistoricalPrice> getHistoricalPrices(int var1) throws CoinbaseException, IOException;

    public List<HistoricalPrice> getHistoricalPrices() throws CoinbaseException, IOException;

    public Report createReport(Report var1) throws CoinbaseException, IOException;

    public Report getReport(String var1) throws CoinbaseException, IOException;

    public ReportsResponse getReports(int var1) throws CoinbaseException, IOException;

    public ReportsResponse getReports() throws CoinbaseException, IOException;

    public AccountChangesResponse getAccountChanges(int var1) throws CoinbaseException, IOException;

    public AccountChangesResponse getAccountChanges() throws CoinbaseException, IOException;

    public String getAuthCode(OAuthCodeRequest var1) throws CredentialsIncorrectException, TwoFactorRequiredException, TwoFactorIncorrectException, CoinbaseException, IOException;

    public OAuthTokensResponse getTokens(String var1, String var2, String var3, String var4) throws UnauthorizedDeviceException, CoinbaseException, IOException;

    public void revokeToken() throws CoinbaseException, IOException;

    public OAuthTokensResponse refreshTokens(String var1, String var2, String var3) throws CoinbaseException, IOException;

    public void sendSMS(String var1, String var2, String var3, String var4) throws CoinbaseException, IOException;

    public URI getAuthorizationUri(OAuthCodeRequest var1) throws CoinbaseException;
}

