/*
 * Decompiled with CFR 0.152.
 */
package com.coinbase.api;

import com.coinbase.api.deserializer.CurrencyUnitDeserializer;
import com.coinbase.api.deserializer.MoneyDeserializer;
import com.coinbase.api.serializer.CurrencyUnitSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class ObjectMapperProvider {
    final ObjectMapper defaultObjectMapper = ObjectMapperProvider.createDefaultMapper();

    public ObjectMapper getContext(Class<?> type) {
        return this.defaultObjectMapper;
    }

    public static ObjectMapper createDefaultMapper() {
        ObjectMapper result = new ObjectMapper();
        result.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        result.configure(SerializationFeature.INDENT_OUTPUT, false);
        result.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        result.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Money.class, (JsonDeserializer)new MoneyDeserializer());
        module.addDeserializer(CurrencyUnit.class, (JsonDeserializer)new CurrencyUnitDeserializer());
        module.addSerializer(CurrencyUnit.class, (JsonSerializer)new CurrencyUnitSerializer());
        result.registerModule((Module)module);
        result.registerModule((Module)new JodaModule());
        return result;
    }
}

