/*
 * Decompiled with CFR 0.152.
 */
package com.coinbase.api.entity;

import com.coinbase.api.deserializer.MoneyDeserializer;
import com.coinbase.api.entity.Account;
import com.coinbase.api.entity.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.math.BigDecimal;
import org.joda.money.Money;
import org.joda.time.DateTime;

public class Transaction
implements Serializable {
    private static final long serialVersionUID = 2817857314208431664L;
    private String _id;
    private DateTime _createdAt;
    private String _hsh;
    private String _idem;
    private String _notes;
    private String _userFee;
    private Money _amount;
    private Boolean _request;
    private Status _status;
    private User _sender;
    private User _recipient;
    private String _recipientAddress;
    private String _amountString;
    private String _amountCurrencyIso;
    private String _from;
    private String _to;
    private Boolean _instantBuy;
    private String _orderId;
    private Integer _confirmations;
    private Account _senderAccount;
    private Account _recipientAccount;
    private DetailedStatus _detailedStatus;

    public Integer getConfirmations() {
        return this._confirmations;
    }

    public void setConfirmations(Integer confirmations) {
        this._confirmations = confirmations;
    }

    public String getTo() {
        return this._to;
    }

    public void setTo(String to) {
        this._to = to;
    }

    public String getFrom() {
        return this._from;
    }

    public void setFrom(String from) {
        this._from = from;
    }

    public String getAmountString() {
        return this._amountString;
    }

    public void setAmountString(String amountString) {
        this._amountString = amountString;
    }

    public String getAmountCurrencyIso() {
        return this._amountCurrencyIso;
    }

    public void setAmountCurrencyIso(String amountCurrencyIso) {
        this._amountCurrencyIso = amountCurrencyIso;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String id) {
        this._id = id;
    }

    public DateTime getCreatedAt() {
        return this._createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this._createdAt = createdAt;
    }

    public String getHsh() {
        return this._hsh;
    }

    public void setHsh(String hsh) {
        this._hsh = hsh;
    }

    public String getHash() {
        return this._hsh;
    }

    public void setHash(String hash) {
        this._hsh = hash;
    }

    public String getNotes() {
        return this._notes;
    }

    public void setNotes(String notes) {
        this._notes = notes;
    }

    @JsonIgnore
    public Money getAmount() {
        return this._amount;
    }

    @JsonProperty
    @JsonDeserialize(using=MoneyDeserializer.class)
    public void setAmount(Money amount) {
        this._amount = amount;
        if (amount != null) {
            this.setAmountString(amount.getAmount().toPlainString());
            this.setAmountCurrencyIso(amount.getCurrencyUnit().getCurrencyCode());
        } else {
            this.setAmountString(null);
            this.setAmountCurrencyIso(null);
        }
    }

    public Boolean isRequest() {
        return this._request;
    }

    public void setRequest(Boolean request) {
        this._request = request;
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(Status status) {
        this._status = status;
    }

    public User getSender() {
        return this._sender;
    }

    public void setSender(User sender) {
        this._sender = sender;
    }

    public User getRecipient() {
        return this._recipient;
    }

    public void setRecipient(User recipient) {
        this._recipient = recipient;
    }

    public String getUserFee() {
        return this._userFee;
    }

    public void setUserFee(BigDecimal userFee) {
        this._userFee = userFee.toPlainString();
    }

    public String getRecipientAddress() {
        return this._recipientAddress;
    }

    public void setRecipientAddress(String recipientAddress) {
        this._recipientAddress = recipientAddress;
    }

    public String getIdem() {
        return this._idem;
    }

    public void setIdem(String idem) {
        this._idem = idem;
    }

    public Boolean getInstantBuy() {
        return this._instantBuy;
    }

    public void setInstantBuy(Boolean instantBuy) {
        this._instantBuy = instantBuy;
    }

    public String getOrderId() {
        return this._orderId;
    }

    public void setOrderId(String orderId) {
        this._orderId = orderId;
    }

    public Account getSenderAccount() {
        return this._senderAccount;
    }

    public void setSenderAccount(Account senderAccount) {
        this._senderAccount = senderAccount;
    }

    public Account getRecipientAccount() {
        return this._recipientAccount;
    }

    public void setRecipientAccount(Account recipientAccount) {
        this._recipientAccount = recipientAccount;
    }

    public DetailedStatus getDetailedStatus() {
        return this._detailedStatus;
    }

    public void setDetailedStatus(DetailedStatus detailedStatus) {
        this._detailedStatus = detailedStatus;
    }

    public static enum DetailedStatus {
        COMPLETED("completed"),
        FAILED("failed"),
        EXPIRED("expired"),
        WAITING_FOR_SIGNATURE("waiting_for_signature"),
        WAITING_FOR_CLEARING("waiting_for_clearing"),
        CANCELED("canceled"),
        PENDING("pending");

        private String _value;

        private DetailedStatus(String value) {
            this._value = value;
        }

        @JsonValue
        public String toString() {
            return this._value;
        }

        @JsonCreator
        public static DetailedStatus create(String val) {
            for (DetailedStatus status : DetailedStatus.values()) {
                if (!status.toString().equalsIgnoreCase(val)) continue;
                return status;
            }
            return null;
        }
    }

    public static enum Status {
        PENDING("pending"),
        COMPLETE("complete");

        private String _value;

        private Status(String value) {
            this._value = value;
        }

        @JsonValue
        public String toString() {
            return this._value;
        }

        @JsonCreator
        public static Status create(String val) {
            for (Status status : Status.values()) {
                if (!status.toString().equalsIgnoreCase(val)) continue;
                return status;
            }
            return null;
        }
    }
}

