/*
 * Decompiled with CFR 0.152.
 */
package com.comcast.money.http.client;

import com.comcast.money.annotations.Traced;
import com.comcast.money.api.Span;
import com.comcast.money.core.Money$;
import com.comcast.money.core.Tracer;
import com.comcast.money.core.formatters.Formatter;
import com.comcast.money.core.internal.SpanLocal$;
import com.comcast.money.http.client.HttpTraceConfig$;
import java.io.Serializable;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import scala.Function1;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Aspect
@ScalaSignature(bytes="\u0006\u0005\u0005\u0015f\u0001\u0002\n\u0014\u0001yAQ!\n\u0001\u0005\u0002\u0019BQ!\u000b\u0001\u0005\u0002)BQ!\r\u0001\u0005\u0002IBQ!\u000f\u0001\u0005\u0002iBQA\u0016\u0001\u0005\u0002]CQa\u001a\u0001\u0005\u0002!DQ!\u001c\u0001\u0005\u00029DQ\u0001\u001f\u0001\u0005\u0002eDQ! \u0001\u0005\u0002yDq!!\t\u0001\t\u0003\t\u0019\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a&\u0001\t\u0013\tIJA\bIiR\u0004HK]1dK\u0006\u001b\b/Z2u\u0015\t!R#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003-]\tA\u0001\u001b;ua*\u0011\u0001$G\u0001\u0006[>tW-\u001f\u0006\u00035m\tqaY8nG\u0006\u001cHOC\u0001\u001d\u0003\r\u0019w.\\\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003M\ta\u0001\u001e:bG\u0016\u0014X#A\u0016\u0011\u00051zS\"A\u0017\u000b\u00059:\u0012\u0001B2pe\u0016L!\u0001M\u0017\u0003\rQ\u0013\u0018mY3s\u0003%1wN]7biR,'/F\u00014!\t!t'D\u00016\u0015\t1T&\u0001\u0006g_Jl\u0017\r\u001e;feNL!\u0001O\u001b\u0003\u0013\u0019{'/\\1ui\u0016\u0014\u0018A\u0002;sC\u000e,G\r\u0006\u0002<}A\u0011\u0001\u0005P\u0005\u0003{\u0005\u0012A!\u00168ji\")q\b\u0002a\u0001\u0001\u0006yAO]1dK\u0006sgn\u001c;bi&|g\u000e\u0005\u0002B\t6\t!I\u0003\u0002D/\u0005Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0013\t)%I\u0001\u0004Ue\u0006\u001cW\r\u001a\u0015\u0005\t\u001d\u001bF\u000b\u0005\u0002I#6\t\u0011J\u0003\u0002K\u0017\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u00051k\u0015\u0001\u00027b]\u001eT!AT(\u0002\u000f\u0005\u001c\b/Z2uU*\t\u0001+A\u0002pe\u001eL!AU%\u0003\u0011A{\u0017N\u001c;dkR\fQA^1mk\u0016\f\u0013!V\u0001YKb,7-\u001e;j_:D\u0003iY8n]\r|WnY1ti:jwN\\3z]\u0005tgn\u001c;bi&|gn\u001d\u0018Ue\u0006\u001cW\r\u001a\u0011+A)BcFL\u0015*A\u00192\u0003\u0005Q1o]>$\u0018\r^5p]\"\"(/Y2f\u0003:tw\u000e^1uS>t\u0017&A\tiiR\u00048\t\\5f]R,\u00050Z2vi\u0016$\"a\u000f-\t\u000be+\u0001\u0019\u0001.\u0002\u0017!$H\u000f\u001d*fcV,7\u000f\u001e\t\u00037\nl\u0011\u0001\u0018\u0006\u0003;z\u000bq!\\3uQ>$7O\u0003\u0002\u0015?*\u0011a\u0003\u0019\u0006\u0003C>\u000ba!\u00199bG\",\u0017BA2]\u00059AE\u000f\u001e9Ve&\u0014V-];fgRDC!B$TK\u0006\na-AA#Kb,7-\u001e;j_:D\u0003/\u001e2mS\u000e\u0004sN]4/CB\f7\r[3/QR$\bO\f%uiB\u0014Vm\u001d9p]N,\u0007e\u001c:h]\u0005\u0004\u0018m\u00195f]!$H\u000f\u001d\u0018dY&,g\u000e\u001e\u0018IiR\u00048\t\\5f]R\\c&\u001a=fGV$X\rK8sO:\n\u0007/Y2iK:BG\u000f\u001e9/G2LWM\u001c;/[\u0016$\bn\u001c3t]!#H\u000f]+sSJ+\u0017/^3ti.b\u0003E\f\u0018*S\u00012c\u0005I1sOND\u0003\u000e\u001e;q%\u0016\fX/Z:uS\u0005\u0011\u0003\u000e\u001e;q\u00072LWM\u001c;Fq\u0016\u001cW\u000f^3U_J+7\u000f]8og\u0016D\u0015M\u001c3mKJ$\"aO5\t\u000be3\u0001\u0019\u0001.)\t\u001995k[\u0011\u0002Y\u0006\tI&\u001a=fGV$\u0018n\u001c8)aV\u0014G.[2!U\u0001z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018iiR\u0004hf\u00197jK:$h\u0006\u0013;ua\u000ec\u0017.\u001a8uW9*\u00070Z2vi\u0016DsN]4/CB\f7\r[3/QR$\bOL2mS\u0016tGOL7fi\"|Gm\u001d\u0018IiR\u0004XK]5SKF,Xm\u001d;,Y\u0001z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018iiR\u0004hf\u00197jK:$hFU3ta>t7/\u001a%b]\u0012dWM]\u0016*S\u00012c\u0005I1sOND\u0003\u000e\u001e;q%\u0016\fX/Z:uS\u0005\u0019\u0002\u000e\u001e;q%\u0016\u001c\bo\u001c8tK\"\u000bg\u000e\u001a7feR\u00111h\u001c\u0005\u0006a\u001e\u0001\r!]\u0001\rQR$\bOU3ta>t7/\u001a\t\u0003eNl\u0011aX\u0005\u0003i~\u0013A\u0002\u0013;uaJ+7\u000f]8og\u0016DCaB$Tm\u0006\nq/\u0001@fq\u0016\u001cW\u000f^5p]\"\u0002XO\u00197jG\u0002R\u0003e\u001c:h]\u0005\u0004\u0018m\u00195f]!$H\u000f\u001d\u0018dY&,g\u000e\u001e\u0018SKN\u0004xN\\:f\u0011\u0006tG\r\\3sW9B\u0017M\u001c3mKJ+7\u000f]8og\u0016DsN]4/CB\f7\r[3/QR$\bO\f%uiB\u0014Vm\u001d9p]N,\u0017&\u000b\u0011'M\u0001\n'oZ:)QR$\bOU3ta>t7/Z\u0015\u0002#\r|gn];nK\"#H\u000f]#oi&$\u0018\u0010F\u0001<Q\u0011AqiU>\"\u0003q\f\u0011qP3yK\u000e,H/[8oQ)\u0002sN]4/CB\f7\r[3/QR$\bOL;uS2tSI\u001c;jif,F/\u001b7t]Q|7\u000b\u001e:j]\u001eDcFL\u0015*Aqd\b%\u001a=fGV$\u0018n\u001c8)U\u0001z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018iiR\u0004h&\u001e;jY:*e\u000e^5usV#\u0018\u000e\\:/i>\u0014\u0015\u0010^3BeJ\f\u0017\u0010\u000b\u0018/S%\u0002C\u0010 \u0011fq\u0016\u001cW\u000f^5p]\"R\u0003e\u001c:h]\u0005\u0004\u0018m\u00195f]!$H\u000f\u001d\u0018vi&dg&\u00128uSRLX\u000b^5mg:\u001awN\\:v[\u0016\fV/[3uYfDcFL\u0015*\u0003]\tGM^5tK\"#H\u000f]\"mS\u0016tG/\u0012=fGV$X\r\u0006\u0004 \u007f\u0006-\u0011Q\u0002\u0005\b\u0003\u0003I\u0001\u0019AA\u0002\u0003%Qw.\u001b8Q_&tG\u000f\u0005\u0003\u0002\u0006\u0005\u001dQ\"A&\n\u0007\u0005%1JA\nQe>\u001cW-\u001a3j]\u001eTu.\u001b8Q_&tG\u000fC\u0003Z\u0013\u0001\u0007!\fC\u0003@\u0013\u0001\u0007\u0001\t\u000b\u0006\n\u0003#\u0019\u0016qCA\u000e\u0003;\u00012\u0001SA\n\u0013\r\t)\"\u0013\u0002\u0007\u0003J|WO\u001c3\"\u0005\u0005e\u0011\u0001\u00115uiB\u001cE.[3oi\u0016CXmY;uK\"BG\u000f\u001e9SKF,Xm\u001d;*A\u00192\u0003e\u00194m_^DCO]1dK\u0012DCO]1dK\u0006sgn\u001c;bi&|g.K\u0015\u0002\u0011\u0005\u0014xMT1nKN\f#!a\b\u0002O)|\u0017N\u001c)pS:$H\u0006\t5uiB\u0014V-];fgRd\u0003\u0005\u001e:bG\u0016\feN\\8uCRLwN\\\u0001\u0018C\u00124\u0018n]3SK\u000e,\u0017N^3F]RLG/\u001f\"pIf$RaHA\u0013\u0003OAq!!\u0001\u000b\u0001\u0004\t\u0019\u0001C\u0003@\u0015\u0001\u0007\u0001\t\u000b\u0006\u000b\u0003#\u0019\u00161FA\u000e\u0003_\t#!!\f\u0002k\r|gn];nK\"#H\u000f]#oi&$\u0018\u0010K\u0015!M\u0019\u00023M\u001a7po\"\"(/Y2fI\"\"(/Y2f\u0003:tw\u000e^1uS>t\u0017&K\u0011\u0003\u0003c\t!D[8j]B{\u0017N\u001c;-AQ\u0014\u0018mY3B]:|G/\u0019;j_:\f\u0001&\u00193wSN,\u0007\n\u001e;q\u00072LWM\u001c;Fq\u0016\u001cW\u000f^3U_J+7\u000f]8og\u0016D\u0015M\u001c3mKJ$RaOA\u001c\u0003sAQ!W\u0006A\u0002iCQaP\u0006A\u0002\u0001C#bCA\u001f'\u0006\r\u00131DA$!\rA\u0015qH\u0005\u0004\u0003\u0003J%A\u0002\"fM>\u0014X-\t\u0002\u0002F\u0005\t\u0006\u000e\u001e;q\u00072LWM\u001c;Fq\u0016\u001cW\u000f^3U_J+7\u000f]8og\u0016D\u0015M\u001c3mKJD\u0003\u000e\u001e;q%\u0016\fX/Z:uS\u00012c\u0005I2gY><\b\u0006\u001e:bG\u0016$\u0007\u0006\u001e:bG\u0016\feN\\8uCRLwN\\\u0015*C\t\tI%\u0001\u000fiiR\u0004(+Z9vKN$H\u0006\t;sC\u000e,\u0017I\u001c8pi\u0006$\u0018n\u001c8\u00023\u0005$g/[:f\u0011R$\bOU3ta>t7/\u001a%b]\u0012dWM\u001d\u000b\b?\u0005=\u0013\u0011KA*\u0011\u001d\t\t\u0001\u0004a\u0001\u0003\u0007AQ\u0001\u001d\u0007A\u0002EDQa\u0010\u0007A\u0002\u0001C#\u0002DA\t'\u0006]\u00131DA.C\t\tI&A\"iiR\u0004(+Z:q_:\u001cX\rS1oI2,'\u000f\u000b5uiB\u0014Vm\u001d9p]N,\u0017\u0006\t\u0014'A\r4Gn\\<)iJ\f7-\u001a3)iJ\f7-Z!o]>$\u0018\r^5p]&J\u0013EAA/\u0003!Rw.\u001b8Q_&tG\u000f\f\u0011iiR\u0004(+Z:q_:\u001cX\r\f\u0011ue\u0006\u001cW-\u00118o_R\fG/[8o\u0003A\u0011WmZ5o\u0011R$\b/\u0012=fGV$X\rF\u0002<\u0003GBq!!\u001a\u000e\u0001\u0004\t9'A\u0002lKf\u0004B!!\u001b\u0002x9!\u00111NA:!\r\ti'I\u0007\u0003\u0003_R1!!\u001d\u001e\u0003\u0019a$o\\8u}%\u0019\u0011QO\u0011\u0002\rA\u0013X\rZ3g\u0013\u0011\tI(a\u001f\u0003\rM#(/\u001b8h\u0015\r\t)(I\u0001\u000fK:$\u0007\n\u001e;q\u000bb,7-\u001e;f)\rY\u0014\u0011\u0011\u0005\b\u0003Kr\u0001\u0019AA4\u0003Q)g\u000eZ\"p]N,X.\u001a%uiB,e\u000e^5usR\u00191(a\"\t\u000f\u0005\u0015t\u00021\u0001\u0002h\u0005iq-\u001a;Ti\u0006$Xo]\"pI\u0016$B!!$\u0002\u0014B\u0019\u0001%a$\n\u0007\u0005E\u0015EA\u0002J]RDa!!&\u0011\u0001\u0004y\u0012\u0001\u00069pgNL'\r\\3IiR\u0004(+Z:q_:\u001cX-\u0001\bbI\u0012$&/Y2f\u0011\u0016\fG-\u001a:\u0015\u0007m\nY\nC\u0003Z#\u0001\u0007!\fK\u0002\u0001\u0003?\u00032\u0001SAQ\u0013\r\t\u0019+\u0013\u0002\u0007\u0003N\u0004Xm\u0019;")
public class HttpTraceAspect {
    public Tracer tracer() {
        return Money$.MODULE$.Environment().tracer();
    }

    public Formatter formatter() {
        return Money$.MODULE$.Environment().formatter();
    }

    @Pointcut(value="execution(@com.comcast.money.annotations.Traced * *(..)) && @annotation(traceAnnotation)")
    public void traced(Traced traceAnnotation) {
    }

    @Pointcut(value="execution(public org.apache.http.HttpResponse org.apache.http.client.HttpClient+.execute(org.apache.http.client.methods.HttpUriRequest+, ..)) && args(httpRequest)")
    public void httpClientExecute(HttpUriRequest httpRequest) {
    }

    @Pointcut(value="execution(public * org.apache.http.client.HttpClient+.execute(org.apache.http.client.methods.HttpUriRequest+, org.apache.http.client.ResponseHandler+)) && args(httpRequest)")
    public void httpClientExecuteToResponseHandler(HttpUriRequest httpRequest) {
    }

    @Pointcut(value="execution(public * org.apache.http.client.ResponseHandler+.handleResponse(org.apache.http.HttpResponse)) && args(httpResponse)")
    public void httpResponseHandler(HttpResponse httpResponse) {
    }

    @Pointcut(value="execution(* org.apache.http.util.EntityUtils.toString(..)) || execution(* org.apache.http.util.EntityUtils.toByteArray(..)) || execution(* org.apache.http.util.EntityUtils.consumeQuietly(..))")
    public void consumeHttpEntity() {
    }

    @Around(value="httpClientExecute(httpRequest) && cflow(traced(traceAnnotation))", argNames="joinPoint, httpRequest, traceAnnotation")
    public Object adviseHttpClientExecute(ProceedingJoinPoint joinPoint, HttpUriRequest httpRequest, Traced traceAnnotation) {
        Object object;
        int statusCode = 0;
        try {
            this.beginHttpExecute(traceAnnotation.value());
            this.addTraceHeader(httpRequest);
            Object httpResponse = joinPoint.proceed();
            statusCode = this.getStatusCode(httpResponse);
            object = httpResponse;
        }
        finally {
            this.tracer().record(HttpTraceConfig$.MODULE$.HttpResponseCodeTraceKey(), (long)statusCode);
            this.endHttpExecute(traceAnnotation.value());
        }
        return object;
    }

    @Around(value="consumeHttpEntity() && cflow(traced(traceAnnotation))", argNames="joinPoint, traceAnnotation")
    public Object adviseReceiveEntityBody(ProceedingJoinPoint joinPoint, Traced traceAnnotation) {
        Object object;
        try {
            try {
                object = joinPoint.proceed();
            }
            catch (Throwable ex) {
                this.tracer().record(HttpTraceConfig$.MODULE$.HttpResponseCodeTraceKey(), 0L);
                throw ex;
            }
        }
        finally {
            this.endConsumeHttpEntity(traceAnnotation.value());
        }
        return object;
    }

    @Before(value="httpClientExecuteToResponseHandler(httpRequest) && cflow(traced(traceAnnotation))", argNames="httpRequest, traceAnnotation")
    public void adviseHttpClientExecuteToResponseHandler(HttpUriRequest httpRequest, Traced traceAnnotation) {
        this.beginHttpExecute(traceAnnotation.value());
        this.addTraceHeader(httpRequest);
    }

    @Around(value="httpResponseHandler(httpResponse) && cflow(traced(traceAnnotation))", argNames="joinPoint, httpResponse, traceAnnotation")
    public Object adviseHttpResponseHandler(ProceedingJoinPoint joinPoint, HttpResponse httpResponse, Traced traceAnnotation) {
        Object object;
        boolean statusCodeIsNotSet = true;
        try {
            this.endHttpExecute(traceAnnotation.value());
            this.tracer().record(HttpTraceConfig$.MODULE$.HttpResponseCodeTraceKey(), (long)this.getStatusCode(httpResponse));
            statusCodeIsNotSet = false;
            object = joinPoint.proceed();
        }
        catch (Throwable ex) {
            if (statusCodeIsNotSet) {
                this.tracer().record(HttpTraceConfig$.MODULE$.HttpResponseCodeTraceKey(), 0L);
            }
            throw ex;
        }
        return object;
    }

    private void beginHttpExecute(String key) {
        this.tracer().startTimer(HttpTraceConfig$.MODULE$.HttpResponseTimeTraceKey());
        this.tracer().startTimer(HttpTraceConfig$.MODULE$.HttpFullResponseTimeTraceKey());
    }

    private void endHttpExecute(String key) {
        this.tracer().stopTimer(HttpTraceConfig$.MODULE$.HttpResponseTimeTraceKey());
    }

    private void endConsumeHttpEntity(String key) {
        this.tracer().stopTimer(HttpTraceConfig$.MODULE$.HttpFullResponseTimeTraceKey());
        this.tracer().startTimer(HttpTraceConfig$.MODULE$.ProcessResponseTimeTraceKey());
    }

    private int getStatusCode(Object possibleHttpResponse) {
        int statusCode;
        block0: {
            HttpResponse response;
            statusCode = 0;
            if (possibleHttpResponse == null || !(possibleHttpResponse instanceof HttpResponse) || (response = (HttpResponse)possibleHttpResponse).getStatusLine() == null) break block0;
            statusCode = response.getStatusLine().getStatusCode();
        }
        return statusCode;
    }

    private void addTraceHeader(HttpUriRequest httpRequest) {
        if (httpRequest != null) {
            SpanLocal$.MODULE$.current().foreach((Function1 & Serializable)span -> {
                HttpTraceAspect.$anonfun$addTraceHeader$1(this, httpRequest, span);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addTraceHeader$1(HttpTraceAspect $this, HttpUriRequest httpRequest$1, Span span) {
        $this.formatter().toHttpHeaders(span.info().id(), (Function2 & Serializable)(x$1, x$2) -> {
            httpRequest$1.setHeader(x$1, x$2);
            return BoxedUnit.UNIT;
        });
    }
}

