/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.helpers;

import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.api.models.cart_discount.CartDiscountDraftBuilder;
import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.services.TypeService;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

public final class CartDiscountReferenceResolver
extends CustomReferenceResolver<CartDiscountDraft, CartDiscountDraftBuilder, CartDiscountSyncOptions> {
    static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CartDiscountDraft with key:'%s'.";

    public CartDiscountReferenceResolver(@Nonnull CartDiscountSyncOptions options, @Nonnull TypeService typeService) {
        super(options, typeService);
    }

    @Override
    @Nonnull
    public CompletionStage<CartDiscountDraft> resolveReferences(@Nonnull CartDiscountDraft draft) {
        return this.resolveCustomTypeReference(CartDiscountDraftBuilder.of((CartDiscountDraft)draft)).thenApply(CartDiscountDraftBuilder::build);
    }

    @Override
    protected CompletionStage<CartDiscountDraftBuilder> resolveCustomTypeReference(@Nonnull CartDiscountDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, CartDiscountDraftBuilder::getCustom, CartDiscountDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }
}

