/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.api.models.cart_discount.CartDiscount;
import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.api.models.cart_discount.CartDiscountDraftBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountValue;
import com.commercetools.api.models.cart_discount.CartDiscountValueAbsolute;
import com.commercetools.api.models.cart_discount.CartDiscountValueAbsoluteDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueAbsoluteDraftBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountValueDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueFixed;
import com.commercetools.api.models.cart_discount.CartDiscountValueFixedDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueFixedDraftBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountValueGiftLineItem;
import com.commercetools.api.models.cart_discount.CartDiscountValueGiftLineItemDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueGiftLineItemDraftBuilder;
import com.commercetools.api.models.cart_discount.CartDiscountValueRelative;
import com.commercetools.api.models.cart_discount.CartDiscountValueRelativeDraft;
import com.commercetools.api.models.cart_discount.CartDiscountValueRelativeDraftBuilder;
import com.commercetools.api.models.common.MoneyBuilder;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CartDiscountReferenceResolutionUtils {
    @Nonnull
    public static List<CartDiscountDraft> mapToCartDiscountDrafts(@Nonnull List<CartDiscount> cartDiscounts, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return cartDiscounts.stream().map(cartDiscount -> CartDiscountReferenceResolutionUtils.mapToCartDiscountDraft(cartDiscount, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CartDiscountDraft mapToCartDiscountDraft(@Nonnull CartDiscount cartDiscount, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return CartDiscountDraftBuilder.of().cartPredicate(cartDiscount.getCartPredicate()).name(cartDiscount.getName()).requiresDiscountCode(cartDiscount.getRequiresDiscountCode()).sortOrder(cartDiscount.getSortOrder()).target(cartDiscount.getTarget()).value(CartDiscountReferenceResolutionUtils.toCartDiscountValueDraft(cartDiscount.getValue())).key(cartDiscount.getKey()).description(cartDiscount.getDescription()).isActive(cartDiscount.getIsActive()).validFrom(cartDiscount.getValidFrom()).validUntil(cartDiscount.getValidUntil()).stackingMode(cartDiscount.getStackingMode()).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(cartDiscount, referenceIdToKeyCache)).build();
    }

    private static CartDiscountValueDraft toCartDiscountValueDraft(CartDiscountValue cartDiscountValue) {
        if (cartDiscountValue instanceof CartDiscountValueAbsolute) {
            return CartDiscountReferenceResolutionUtils.cloneCartDiscountValueAbsoluteDraft((CartDiscountValueAbsolute)cartDiscountValue);
        }
        if (cartDiscountValue instanceof CartDiscountValueFixed) {
            return CartDiscountReferenceResolutionUtils.cloneCartDiscountValueFixedDraft((CartDiscountValueFixed)cartDiscountValue);
        }
        if (cartDiscountValue instanceof CartDiscountValueGiftLineItem) {
            return CartDiscountReferenceResolutionUtils.cloneCartDiscountValueGiftLineItemDraft((CartDiscountValueGiftLineItem)cartDiscountValue);
        }
        if (cartDiscountValue instanceof CartDiscountValueRelative) {
            return CartDiscountReferenceResolutionUtils.cloneCartDiscountValueRelativeDraft((CartDiscountValueRelative)cartDiscountValue);
        }
        return null;
    }

    private static CartDiscountValueRelativeDraft cloneCartDiscountValueRelativeDraft(CartDiscountValueRelative cartDiscountValueRelative) {
        return CartDiscountValueRelativeDraftBuilder.of().permyriad(cartDiscountValueRelative.getPermyriad()).build();
    }

    private static CartDiscountValueGiftLineItemDraft cloneCartDiscountValueGiftLineItemDraft(CartDiscountValueGiftLineItem cartDiscountValueGiftLineItem) {
        CartDiscountValueGiftLineItemDraftBuilder builder = CartDiscountValueGiftLineItemDraftBuilder.of().product(productResourceIdentifierBuilder -> productResourceIdentifierBuilder.id(cartDiscountValueGiftLineItem.getProduct().getId())).variantId(cartDiscountValueGiftLineItem.getVariantId());
        if (cartDiscountValueGiftLineItem.getDistributionChannel() != null) {
            builder.distributionChannel(channelResourceIdentifierBuilder -> channelResourceIdentifierBuilder.id(cartDiscountValueGiftLineItem.getDistributionChannel().getId()));
        }
        if (cartDiscountValueGiftLineItem.getSupplyChannel() != null) {
            builder.supplyChannel(channelResourceIdentifierBuilder -> channelResourceIdentifierBuilder.id(cartDiscountValueGiftLineItem.getSupplyChannel().getId()));
        }
        return builder.build();
    }

    private static CartDiscountValueFixedDraft cloneCartDiscountValueFixedDraft(CartDiscountValueFixed cartDiscountValueFixed) {
        return CartDiscountValueFixedDraftBuilder.of().money(cartDiscountValueFixed.getMoney().stream().map(centPrecisionMoney -> MoneyBuilder.of().currencyCode(centPrecisionMoney.getCurrencyCode()).centAmount(centPrecisionMoney.getCentAmount()).build()).collect(Collectors.toList())).build();
    }

    private static CartDiscountValueAbsoluteDraft cloneCartDiscountValueAbsoluteDraft(CartDiscountValueAbsolute cartDiscountValueAbsolute) {
        return CartDiscountValueAbsoluteDraftBuilder.of().money(cartDiscountValueAbsolute.getMoney().stream().map(centPrecisionMoney -> MoneyBuilder.of().currencyCode(centPrecisionMoney.getCurrencyCode()).centAmount(centPrecisionMoney.getCentAmount()).build()).collect(Collectors.toList())).build();
    }

    private CartDiscountReferenceResolutionUtils() {
    }
}

