/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategorySyncStatistics;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CategoryBatchValidator
extends BaseBatchValidator<CategoryDraft, CategorySyncOptions, CategorySyncStatistics> {
    public static final String CATEGORY_DRAFT_KEY_NOT_SET = "CategoryDraft with name: %s doesn't have a key. Please make sure all category drafts have keys.";
    static final String CATEGORY_DRAFT_IS_NULL = "CategoryDraft is null.";

    public CategoryBatchValidator(@Nonnull CategorySyncOptions syncOptions, @Nonnull CategorySyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<CategoryDraft>, ReferencedKeys> validateAndCollectReferencedKeys(@Nonnull List<CategoryDraft> categoryDrafts) {
        ReferencedKeys referencedKeys = new ReferencedKeys();
        Set validDrafts = categoryDrafts.stream().filter(this::isValidCategoryDraft).peek(categoryDraft -> this.collectReferencedKeys(referencedKeys, (CategoryDraft)categoryDraft)).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, (Object)referencedKeys);
    }

    private boolean isValidCategoryDraft(@Nullable CategoryDraft categoryDraft) {
        if (categoryDraft == null) {
            this.handleError(CATEGORY_DRAFT_IS_NULL);
        } else if (StringUtils.isBlank((CharSequence)categoryDraft.getKey())) {
            this.handleError(String.format(CATEGORY_DRAFT_KEY_NOT_SET, categoryDraft.getName()));
        } else {
            return true;
        }
        return false;
    }

    private void collectReferencedKeys(@Nonnull ReferencedKeys referencedKeys, @Nonnull CategoryDraft categoryDraft) {
        referencedKeys.categoryKeys.add(categoryDraft.getKey());
        this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)categoryDraft.getParent(), referencedKeys.categoryKeys::add);
        this.collectReferencedKeyFromCustomFieldsDraft(categoryDraft.getCustom(), referencedKeys.typeKeys::add);
        this.collectReferencedKeysFromAssetDrafts(categoryDraft.getAssets(), referencedKeys.typeKeys::add);
    }

    public static class ReferencedKeys {
        private final Set<String> categoryKeys = new HashSet<String>();
        private final Set<String> typeKeys = new HashSet<String>();

        public Set<String> getCategoryKeys() {
            return this.categoryKeys;
        }

        public Set<String> getTypeKeys() {
            return this.typeKeys;
        }
    }
}

