/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryCustomActionBuilder;
import com.commercetools.sync.categories.models.CategoryCustomTypeAdapter;
import com.commercetools.sync.categories.models.CategoryDraftCustomTypeAdapter;
import com.commercetools.sync.categories.utils.CategoryUpdateActionUtils;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class CategorySyncUtils {
    private static final CategoryCustomActionBuilder categoryCustomActionBuilder = new CategoryCustomActionBuilder();

    @Nonnull
    public static List<CategoryUpdateAction> buildActions(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        List<CategoryUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(CategoryUpdateActionUtils.buildChangeNameUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildChangeSlugUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetExternalIdUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetDescriptionUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildChangeParentUpdateAction(oldCategory, newCategory, syncOptions), CategoryUpdateActionUtils.buildChangeOrderHintUpdateAction(oldCategory, newCategory, syncOptions), CategoryUpdateActionUtils.buildSetMetaTitleUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetMetaDescriptionUpdateAction(oldCategory, newCategory), CategoryUpdateActionUtils.buildSetMetaKeywordsUpdateAction(oldCategory, newCategory));
        List<CategoryUpdateAction> categoryCustomUpdateActions = CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(CategoryCustomTypeAdapter.of(oldCategory), CategoryDraftCustomTypeAdapter.of(newCategory), categoryCustomActionBuilder, syncOptions);
        List<CategoryUpdateAction> assetsUpdateActions = CategoryUpdateActionUtils.buildAssetsUpdateActions(oldCategory, newCategory, syncOptions);
        updateActions.addAll(categoryCustomUpdateActions);
        updateActions.addAll(assetsUpdateActions);
        return updateActions;
    }

    private CategorySyncUtils() {
    }
}

