/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryChangeNameActionBuilder;
import com.commercetools.api.models.category.CategoryChangeOrderHintActionBuilder;
import com.commercetools.api.models.category.CategoryChangeParentActionBuilder;
import com.commercetools.api.models.category.CategoryChangeSlugActionBuilder;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryReference;
import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.category.CategorySetDescriptionActionBuilder;
import com.commercetools.api.models.category.CategorySetExternalIdActionBuilder;
import com.commercetools.api.models.category.CategorySetMetaDescriptionActionBuilder;
import com.commercetools.api.models.category.CategorySetMetaKeywordsActionBuilder;
import com.commercetools.api.models.category.CategorySetMetaTitleActionBuilder;
import com.commercetools.api.models.category.CategoryUpdateAction;
import com.commercetools.sync.categories.CategorySyncOptions;
import com.commercetools.sync.categories.helpers.CategoryAssetActionFactory;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.AssetsUpdateActionUtils;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

public final class CategoryUpdateActionUtils {
    private static final String CATEGORY_CHANGE_PARENT_EMPTY_PARENT = "Cannot unset 'parent' field of category with id '%s'.";
    private static final String CATEGORY_CHANGE_ORDER_HINT_EMPTY_ORDERHINT = "Cannot unset 'orderHint' field of category with id '%s'.";

    @Nonnull
    public static Optional<CategoryUpdateAction> buildChangeNameUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getName(), newCategory.getName(), () -> CategoryChangeNameActionBuilder.of().name(newCategory.getName()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildChangeSlugUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getSlug(), newCategory.getSlug(), () -> CategoryChangeSlugActionBuilder.of().slug(newCategory.getSlug()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetDescriptionUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getDescription(), newCategory.getDescription(), () -> CategorySetDescriptionActionBuilder.of().description(newCategory.getDescription()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildChangeParentUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        CategoryReference oldParent = oldCategory.getParent();
        CategoryResourceIdentifier newParent = newCategory.getParent();
        if (newParent == null && oldParent != null) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CATEGORY_CHANGE_PARENT_EMPTY_PARENT, oldCategory.getId())), oldCategory, newCategory);
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldParent, newParent, () -> CategoryChangeParentActionBuilder.of().parent(CategoryResourceIdentifierBuilder.of().id(newParent.getId()).build()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildChangeOrderHintUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        if (newCategory.getOrderHint() == null && oldCategory.getOrderHint() != null) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CATEGORY_CHANGE_ORDER_HINT_EMPTY_ORDERHINT, oldCategory.getId())), oldCategory, newCategory);
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getOrderHint(), newCategory.getOrderHint(), () -> CategoryChangeOrderHintActionBuilder.of().orderHint(newCategory.getOrderHint()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetMetaTitleUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaTitle(), newCategory.getMetaTitle(), () -> CategorySetMetaTitleActionBuilder.of().metaTitle(newCategory.getMetaTitle()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetMetaKeywordsUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaKeywords(), newCategory.getMetaKeywords(), () -> CategorySetMetaKeywordsActionBuilder.of().metaKeywords(newCategory.getMetaKeywords()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetMetaDescriptionUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getMetaDescription(), newCategory.getMetaDescription(), () -> CategorySetMetaDescriptionActionBuilder.of().metaDescription(newCategory.getMetaDescription()).build());
    }

    @Nonnull
    public static Optional<CategoryUpdateAction> buildSetExternalIdUpdateAction(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCategory.getExternalId(), newCategory.getExternalId(), () -> CategorySetExternalIdActionBuilder.of().externalId(newCategory.getExternalId()).build());
    }

    @Nonnull
    public static List<CategoryUpdateAction> buildAssetsUpdateActions(@Nonnull Category oldCategory, @Nonnull CategoryDraft newCategory, @Nonnull CategorySyncOptions syncOptions) {
        try {
            return AssetsUpdateActionUtils.buildAssetsUpdateActions(newCategory, oldCategory.getAssets(), newCategory.getAssets(), new CategoryAssetActionFactory(syncOptions), syncOptions);
        }
        catch (BuildUpdateActionException exception) {
            syncOptions.applyErrorCallback(new SyncException(String.format("Failed to build update actions for the assets of the category with the key '%s'.", oldCategory.getKey()), exception), oldCategory, newCategory, null);
            return Collections.emptyList();
        }
    }

    private CategoryUpdateActionUtils() {
    }
}

