/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.api.models.common.BaseResource;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import io.vrap.rmf.base.client.error.ConcurrentModificationException;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseSync<ResourceT extends BaseResource, ResourceDraftT, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>, SyncStatisticsT extends BaseSyncStatistics<SyncStatisticsT>, SyncOptionsT extends BaseSyncOptions<ResourceT, ResourceDraftT, ResourceUpdateActionT>> {
    protected final SyncStatisticsT statistics;
    protected final SyncOptionsT syncOptions;

    protected BaseSync(@Nonnull SyncStatisticsT statistics, @Nonnull SyncOptionsT syncOptions) {
        this.statistics = statistics;
        this.syncOptions = syncOptions;
    }

    protected abstract CompletionStage<SyncStatisticsT> process(@Nonnull List<ResourceDraftT> var1);

    public CompletionStage<SyncStatisticsT> sync(@Nonnull List<ResourceDraftT> resourceDrafts) {
        ((BaseSyncStatistics)this.statistics).startTimer();
        return this.process(resourceDrafts).thenApply(resultingStatistics -> {
            resultingStatistics.calculateProcessingTime();
            return resultingStatistics;
        });
    }

    @Nonnull
    public SyncStatisticsT getStatistics() {
        return this.statistics;
    }

    public SyncOptionsT getSyncOptions() {
        return this.syncOptions;
    }

    protected CompletionStage<SyncStatisticsT> syncBatches(@Nonnull List<List<ResourceDraftT>> batches, @Nonnull CompletionStage<SyncStatisticsT> result) {
        if (batches.isEmpty()) {
            return result;
        }
        List<ResourceDraftT> firstBatch = batches.remove(0);
        return this.syncBatches(batches, result.thenCompose(subResult -> this.processBatch(firstBatch)));
    }

    protected abstract CompletionStage<SyncStatisticsT> processBatch(@Nonnull List<ResourceDraftT> var1);

    protected static <ResultT> ResultT executeSupplierIfConcurrentModificationException(@Nonnull Throwable exception, @Nonnull Supplier<ResultT> onConcurrentModificationSupplier, @Nonnull Supplier<ResultT> onOtherExceptionSupplier) {
        Throwable completionExceptionCause = exception.getCause();
        if (completionExceptionCause instanceof ConcurrentModificationException) {
            return onConcurrentModificationSupplier.get();
        }
        return onOtherExceptionSupplier.get();
    }

    protected void handleError(@Nonnull String errorMessage, @Nullable Throwable exception, ResourceT oldResource, ResourceDraftT newResourceDraft, List<ResourceUpdateActionT> updateActions, int failedTimes) {
        SyncException syncException = exception != null ? new SyncException(errorMessage, exception) : new SyncException(errorMessage);
        ((BaseSyncOptions)this.syncOptions).applyErrorCallback(syncException, oldResource, newResourceDraft, updateActions);
        ((BaseSyncStatistics)this.statistics).incrementFailed(failedTimes);
    }
}

