/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.api.models.common.AssetDraft;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class BaseBatchValidator<ResourceDraftT, SyncOptionsT extends BaseSyncOptions, SyncStatisticsT extends BaseSyncStatistics> {
    private final SyncOptionsT syncOptions;
    private final SyncStatisticsT syncStatistics;

    public BaseBatchValidator(@Nonnull SyncOptionsT syncOptions, @Nonnull SyncStatisticsT syncStatistics) {
        this.syncOptions = syncOptions;
        this.syncStatistics = syncStatistics;
    }

    public abstract ImmutablePair<Set<ResourceDraftT>, ?> validateAndCollectReferencedKeys(@Nonnull List<ResourceDraftT> var1);

    protected <T> void collectReferencedKeyFromResourceIdentifier(@Nullable ResourceIdentifier resourceIdentifier, @Nonnull Consumer<String> keyConsumer) {
        if (resourceIdentifier != null && !StringUtils.isBlank((CharSequence)resourceIdentifier.getKey())) {
            keyConsumer.accept(resourceIdentifier.getKey());
        }
    }

    protected void collectReferencedKeyFromCustomFieldsDraft(@Nullable CustomFieldsDraft customFieldsDraft, @Nonnull Consumer<String> keyConsumer) {
        if (customFieldsDraft != null) {
            this.collectReferencedKeyFromResourceIdentifier((ResourceIdentifier)customFieldsDraft.getType(), keyConsumer);
        }
    }

    protected void collectReferencedKeysFromAssetDrafts(@Nullable List<AssetDraft> assetDrafts, @Nonnull Consumer<String> keyConsumer) {
        if (assetDrafts != null) {
            assetDrafts.forEach(assetDraft -> this.collectReferencedKeyFromCustomFieldsDraft(assetDraft.getCustom(), keyConsumer));
        }
    }

    protected void handleError(@Nonnull SyncException syncException) {
        ((BaseSyncOptions)this.syncOptions).applyErrorCallback(syncException);
        ((BaseSyncStatistics)this.syncStatistics).incrementFailed();
    }

    protected void handleError(@Nonnull String errorMessage) {
        this.handleError(new SyncException(errorMessage));
    }
}

