/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.common.ResourceIdentifier;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CommonTypeUpdateActionUtils {
    @Nonnull
    public static <AnyT, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildUpdateAction(@Nullable AnyT oldObject, @Nullable AnyT newObject, @Nonnull Supplier<ResourceUpdateActionT> updateActionSupplier) {
        return !Objects.equals(oldObject, newObject) ? Optional.ofNullable((ResourceUpdateAction)updateActionSupplier.get()) : Optional.empty();
    }

    @Nonnull
    public static <ReferenceT extends Reference, ResourceIdentifierT extends ResourceIdentifier, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> Optional<ResourceUpdateActionT> buildUpdateActionForReferences(@Nullable ReferenceT oldReference, @Nullable ResourceIdentifierT newResourceIdentifier, @Nonnull Supplier<ResourceUpdateActionT> updateActionSupplier) {
        return !CommonTypeUpdateActionUtils.areResourceIdentifiersEqual(oldReference, newResourceIdentifier) ? Optional.ofNullable((ResourceUpdateAction)updateActionSupplier.get()) : Optional.empty();
    }

    public static <ReferenceT extends Reference, ResourceIdentifierT extends ResourceIdentifier> boolean areResourceIdentifiersEqual(@Nullable ReferenceT oldReference, @Nullable ResourceIdentifierT newResourceIdentifier) {
        String oldId = Optional.ofNullable(oldReference).map(Reference::getId).orElse(null);
        String newId = Optional.ofNullable(newResourceIdentifier).map(ResourceIdentifier::getId).orElse(null);
        return Objects.equals(oldId, newId);
    }

    @Nonnull
    public static <AnyT, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> List<ResourceUpdateActionT> buildUpdateActions(@Nullable AnyT oldObject, @Nullable AnyT newObject, @Nonnull Supplier<List<ResourceUpdateActionT>> updateActionSupplier) {
        return !Objects.equals(oldObject, newObject) ? updateActionSupplier.get() : Collections.emptyList();
    }

    private CommonTypeUpdateActionUtils() {
    }
}

