/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.Customizable;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.api.models.type.CustomFieldsDraft;
import com.commercetools.api.models.type.CustomFieldsDraftBuilder;
import com.commercetools.api.models.type.TypeResourceIdentifier;
import com.commercetools.api.models.type.TypeResourceIdentifierBuilder;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class CustomTypeReferenceResolutionUtils {
    @Nullable
    public static <T extends Customizable<T>> CustomFieldsDraft mapToCustomFieldsDraft(@Nonnull T resource, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        CustomFields custom = resource.getCustom();
        return CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(custom, referenceIdToKeyCache);
    }

    @Nullable
    public static CustomFieldsDraft mapToCustomFieldsDraft(@Nullable CustomFields custom, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return Optional.ofNullable(custom).map(fields -> CustomFieldsDraftBuilder.of().fields(fields.getFields()).type((TypeResourceIdentifier)Optional.ofNullable(fields.getType()).map(typeReference -> SyncUtils.getResourceIdentifierWithKey((Reference)typeReference, referenceIdToKeyCache, (id, key) -> TypeResourceIdentifierBuilder.of().key(key).id(id).build())).orElse(null)).build()).orElse(null);
    }

    private CustomTypeReferenceResolutionUtils() {
    }
}

