/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.common.Reference;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class ResourceIdentifierUtils {
    public static final String REFERENCE_TYPE_ID_FIELD = "typeId";
    public static final String REFERENCE_ID_FIELD = "id";

    public static boolean isReferenceOfType(@Nonnull Reference referenceValue, String referenceTypeId) {
        return referenceValue.getTypeId() != null && StringUtils.isNotBlank((CharSequence)referenceValue.getTypeId().getJsonName()) && referenceValue.getTypeId().getJsonName().equals(referenceTypeId);
    }

    public static boolean isReferenceOfType(@Nonnull JsonNode referenceValue, String referenceTypeId) {
        return ResourceIdentifierUtils.getReferenceTypeId(referenceValue).map(resolvedReferenceTypeId -> Objects.equals(resolvedReferenceTypeId, referenceTypeId)).orElse(false);
    }

    @Nonnull
    private static Optional<String> getReferenceTypeId(@Nonnull JsonNode referenceValue) {
        JsonNode typeId = referenceValue.get(REFERENCE_TYPE_ID_FIELD);
        return Optional.ofNullable(typeId).map(JsonNode::asText);
    }

    private ResourceIdentifierUtils() {
    }
}

