/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntryUpdateAction;
import com.commercetools.sync.commons.BaseSyncOptionsBuilder;
import com.commercetools.sync.inventories.InventorySyncOptions;
import javax.annotation.Nonnull;

public final class InventorySyncOptionsBuilder
extends BaseSyncOptionsBuilder<InventorySyncOptionsBuilder, InventorySyncOptions, InventoryEntry, InventoryEntryDraft, InventoryEntryUpdateAction> {
    static final int BATCH_SIZE_DEFAULT = 150;
    static final boolean ENSURE_CHANNELS_DEFAULT = false;
    private boolean ensureChannels = false;

    private InventorySyncOptionsBuilder(@Nonnull ProjectApiRoot ctpClient) {
        this.ctpClient = ctpClient;
    }

    public static InventorySyncOptionsBuilder of(@Nonnull ProjectApiRoot ctpClient) {
        return (InventorySyncOptionsBuilder)new InventorySyncOptionsBuilder(ctpClient).batchSize(150);
    }

    public InventorySyncOptionsBuilder ensureChannels(boolean ensureChannels) {
        this.ensureChannels = ensureChannels;
        return this;
    }

    @Override
    public InventorySyncOptions build() {
        return new InventorySyncOptions(this.ctpClient, this.errorCallback, this.warningCallback, this.batchSize, this.ensureChannels, this.beforeUpdateCallback, this.beforeCreateCallback, this.cacheSize);
    }

    @Override
    protected InventorySyncOptionsBuilder getThis() {
        return this;
    }
}

