/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.api.models.type.TypeReference;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.inventories.utils.InventoryReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class InventoryTransformUtils {
    @Nonnull
    public static CompletableFuture<List<InventoryEntryDraft>> toInventoryEntryDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<InventoryEntry> inventoryEntries) {
        InventoryEntryTransformServiceImpl inventoryEntryTransformService = new InventoryEntryTransformServiceImpl(client, referenceIdToKeyCache);
        return inventoryEntryTransformService.toInventoryEntryDrafts(inventoryEntries);
    }

    private static class InventoryEntryTransformServiceImpl
    extends BaseTransformServiceImpl {
        public InventoryEntryTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<InventoryEntryDraft>> toInventoryEntryDrafts(@Nonnull List<InventoryEntry> inventoryEntries) {
            ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
            transformReferencesToRunParallel.add(this.transformCustomTypeReference(inventoryEntries));
            transformReferencesToRunParallel.add(this.transformChannelReference(inventoryEntries));
            return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.toArray(CompletableFuture[]::new)).thenApply(ignore -> InventoryReferenceResolutionUtils.mapToInventoryEntryDrafts(inventoryEntries, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<InventoryEntry> inventoryEntries) {
            Set<String> setOfTypeIds = inventoryEntries.stream().map(InventoryEntry::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(TypeReference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.TYPES);
        }

        @Nonnull
        private CompletableFuture<Void> transformChannelReference(@Nonnull List<InventoryEntry> inventoryEntries) {
            Set<String> setOfChannelIds = inventoryEntries.stream().map(InventoryEntry::getSupplyChannel).filter(Objects::nonNull).map(ChannelReference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(setOfChannelIds, GraphQlQueryResource.CHANNELS);
        }
    }
}

