/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.helpers;

import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.channel.ChannelResourceIdentifier;
import com.commercetools.api.models.common.Price;
import com.commercetools.api.models.common.PriceDraft;
import com.commercetools.api.models.customer_group.CustomerGroupReference;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifier;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class PriceCompositeId {
    private final String countryCode;
    private final String currencyCode;
    private final String channelId;
    private final String customerGroupId;
    private final ZonedDateTime validFrom;
    private final ZonedDateTime validUntil;

    private PriceCompositeId(@Nonnull String currencyCode, @Nullable String countryCode, @Nullable String channelId, @Nullable String customerGroupId, @Nullable ZonedDateTime validFrom, @Nullable ZonedDateTime validUntil) {
        this.currencyCode = currencyCode;
        this.countryCode = countryCode;
        this.channelId = channelId;
        this.customerGroupId = customerGroupId;
        this.validFrom = validFrom;
        this.validUntil = validUntil;
    }

    @Nonnull
    public static PriceCompositeId of(@Nonnull PriceDraft priceDraft) {
        return new PriceCompositeId(priceDraft.getValue().getCurrency().getCurrencyCode(), priceDraft.getCountry(), Optional.ofNullable(priceDraft.getChannel()).map(ChannelResourceIdentifier::getId).orElse(null), Optional.ofNullable(priceDraft.getCustomerGroup()).map(CustomerGroupResourceIdentifier::getId).orElse(null), priceDraft.getValidFrom(), priceDraft.getValidUntil());
    }

    @Nonnull
    public static PriceCompositeId of(@Nonnull Price price) {
        return new PriceCompositeId(price.getValue().getCurrency().getCurrencyCode(), price.getCountry(), Optional.ofNullable(price.getChannel()).map(ChannelReference::getId).orElse(null), Optional.ofNullable(price.getCustomerGroup()).map(CustomerGroupReference::getId).orElse(null), price.getValidFrom(), price.getValidUntil());
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getCustomerGroupId() {
        return this.customerGroupId;
    }

    public ZonedDateTime getValidFrom() {
        return this.validFrom;
    }

    public ZonedDateTime getValidUntil() {
        return this.validUntil;
    }

    public boolean equals(Object otherObject) {
        if (this == otherObject) {
            return true;
        }
        if (!(otherObject instanceof PriceCompositeId)) {
            return false;
        }
        PriceCompositeId that = (PriceCompositeId)otherObject;
        return Objects.equals(this.countryCode, that.countryCode) && Objects.equals(this.currencyCode, that.currencyCode) && Objects.equals(this.channelId, that.channelId) && Objects.equals(this.customerGroupId, that.customerGroupId) && Objects.equals(this.validFrom, that.validFrom) && Objects.equals(this.validUntil, that.validUntil);
    }

    public int hashCode() {
        return Objects.hash(this.countryCode, this.currencyCode, this.channelId, this.customerGroupId, this.validFrom, this.validUntil);
    }
}

