/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.product.Attribute;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AttributeUtils {
    @Nonnull
    public static JsonNode replaceAttributeValueWithJsonAndReturnValue(@Nonnull Attribute attribute) {
        Object attributeValue = attribute.getValue();
        JsonNode attributeValueAsJson = JsonUtils.toJsonNode((Object)attributeValue);
        attribute.setValue((Object)attributeValueAsJson);
        return attributeValueAsJson;
    }

    public static List<JsonNode> getAttributeReferences(@Nonnull JsonNode attributeValueAsJson) {
        return attributeValueAsJson.findParents("typeId");
    }

    @Nonnull
    public static JsonNode cleanupAttributeValue(@Nonnull JsonNode attributeValueAsJson, @Nonnull Attribute attribute) {
        if (!attributeValueAsJson.isArray()) {
            return AttributeUtils.cleanupAttributeValue((JsonNode)JsonNodeFactory.instance.arrayNode().add(attributeValueAsJson), attribute);
        }
        Iterator entryIterator = attributeValueAsJson.elements();
        while (entryIterator.hasNext()) {
            JsonNode firstValue;
            JsonNode entry = (JsonNode)entryIterator.next();
            List nodeValues = entry.findValues("value");
            JsonNode jsonNode = firstValue = nodeValues.isEmpty() ? entry : (JsonNode)nodeValues.get(0);
            if (firstValue.isArray()) {
                return AttributeUtils.cleanupAttributeValue(firstValue, attribute);
            }
            if (!AttributeUtils.isAttributeEntryValueNullOrInvalid(firstValue)) continue;
            entryIterator.remove();
        }
        return attributeValueAsJson;
    }

    private static boolean isAttributeEntryValueNullOrInvalid(@Nullable JsonNode attributeEntryValue) {
        try {
            return attributeEntryValue == null || JsonUtils.toJsonString((Object)attributeEntryValue).contains("SELF_REFERENCE_ID");
        }
        catch (JsonProcessingException e) {
            return true;
        }
    }
}

