/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.category.CategoryReference;
import com.commercetools.api.models.channel.ChannelReference;
import com.commercetools.api.models.common.Asset;
import com.commercetools.api.models.common.Price;
import com.commercetools.api.models.custom_object.CustomObjectPagedQueryResponse;
import com.commercetools.api.models.customer_group.CustomerGroupReference;
import com.commercetools.api.models.graph_ql.GraphQLRequest;
import com.commercetools.api.models.product.ProductDraft;
import com.commercetools.api.models.product.ProductProjection;
import com.commercetools.api.models.product.ProductVariant;
import com.commercetools.api.models.product_type.ProductTypeReference;
import com.commercetools.api.models.state.StateReference;
import com.commercetools.api.models.tax_category.TaxCategoryReference;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.api.models.type.TypeReference;
import com.commercetools.sync.commons.exceptions.ReferenceTransformException;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ChunkUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.products.utils.AttributeUtils;
import com.commercetools.sync.products.utils.ProductReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductTransformUtils {
    @Nonnull
    public static CompletableFuture<List<ProductDraft>> toProductDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<ProductProjection> products) {
        ProductTransformServiceImpl productTransformService = new ProductTransformServiceImpl(client, referenceIdToKeyCache);
        return productTransformService.toProductDrafts(products);
    }

    private static class ProductTransformServiceImpl
    extends BaseTransformServiceImpl {
        private static final String FAILED_TO_REPLACE_REFERENCES_ON_ATTRIBUTES = "Failed to replace referenced resource ids with keys on the attributes of the products in the current fetched page from the source project. This page will not be synced to the target project.";

        public ProductTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<ProductDraft>> toProductDrafts(@Nonnull List<ProductProjection> products) {
            return this.replaceAttributeReferenceIdsWithKeys(products).handle((productsResolved, throwable) -> {
                if (throwable != null) {
                    throw new ReferenceTransformException(FAILED_TO_REPLACE_REFERENCES_ON_ATTRIBUTES, (Throwable)throwable);
                }
                return productsResolved;
            }).thenCompose(productsWithAttributesResolved -> this.transformReferencesAndMapToProductDrafts((List<ProductProjection>)productsWithAttributesResolved)).toCompletableFuture();
        }

        @Nonnull
        private CompletionStage<List<ProductDraft>> transformReferencesAndMapToProductDrafts(@Nonnull List<ProductProjection> products) {
            ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
            transformReferencesToRunParallel.add(this.transformProductTypeReference(products));
            transformReferencesToRunParallel.add(this.transformTaxCategoryReference(products));
            transformReferencesToRunParallel.add(this.transformStateReference(products));
            transformReferencesToRunParallel.add(this.transformCategoryReference(products));
            transformReferencesToRunParallel.add(this.transformPricesChannelReference(products));
            transformReferencesToRunParallel.add(this.transformCustomTypeReference(products));
            transformReferencesToRunParallel.add(this.transformPricesCustomerGroupReference(products));
            return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> ProductReferenceResolutionUtils.mapToProductDrafts(products, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> transformProductTypeReference(@Nonnull List<ProductProjection> products) {
            Set<String> productTypeIds = products.stream().map(ProductProjection::getProductType).map(ProductTypeReference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(productTypeIds, GraphQlQueryResource.PRODUCT_TYPES);
        }

        @Nonnull
        private CompletableFuture<Void> transformTaxCategoryReference(@Nonnull List<ProductProjection> products) {
            Set<String> taxCategoryIds = products.stream().map(ProductProjection::getTaxCategory).filter(Objects::nonNull).map(TaxCategoryReference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(taxCategoryIds, GraphQlQueryResource.TAX_CATEGORIES);
        }

        @Nonnull
        private CompletableFuture<Void> transformStateReference(@Nonnull List<ProductProjection> products) {
            Set<String> stateIds = products.stream().map(ProductProjection::getState).filter(Objects::nonNull).map(StateReference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(stateIds, GraphQlQueryResource.STATES);
        }

        @Nonnull
        private CompletableFuture<Void> transformCategoryReference(@Nonnull List<ProductProjection> products) {
            Set<String> categoryIds = products.stream().map(ProductProjection::getCategories).filter(Objects::nonNull).map(categories -> categories.stream().map(CategoryReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(categoryIds, GraphQlQueryResource.CATEGORIES);
        }

        @Nonnull
        private CompletableFuture<Void> transformPricesChannelReference(@Nonnull List<ProductProjection> products) {
            Set<String> channelIds = products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getChannel).filter(Objects::nonNull).map(ChannelReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(channelIds, GraphQlQueryResource.CHANNELS);
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<ProductProjection> products) {
            HashSet<String> setOfTypeIds = new HashSet<String>();
            setOfTypeIds.addAll(this.collectPriceCustomTypeIds(products));
            setOfTypeIds.addAll(this.collectAssetCustomTypeIds(products));
            return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.TYPES);
        }

        private Set<String> collectPriceCustomTypeIds(@Nonnull List<ProductProjection> products) {
            return products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(TypeReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private Set<String> collectAssetCustomTypeIds(@Nonnull List<ProductProjection> products) {
            return products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getAssets().stream().map(Asset::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(TypeReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        @Nonnull
        private CompletableFuture<Void> transformPricesCustomerGroupReference(@Nonnull List<ProductProjection> products) {
            Set<String> customerGroupIds = products.stream().map(product -> product.getAllVariants()).map(productVariants -> productVariants.stream().filter(Objects::nonNull).map(productVariant -> productVariant.getPrices().stream().map(Price::getCustomerGroup).filter(Objects::nonNull).map(CustomerGroupReference::getId).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(customerGroupIds, GraphQlQueryResource.CUSTOMER_GROUPS);
        }

        @Nonnull
        public CompletionStage<List<ProductProjection>> replaceAttributeReferenceIdsWithKeys(@Nonnull List<ProductProjection> products) {
            List<JsonNode> allAttributeReferences = this.getAllReferences(products);
            return this.getIdToKeys(allAttributeReferences).thenApply(ignored -> {
                this.replaceReferences(this.getAllReferences(products));
                return products;
            });
        }

        @Nonnull
        private List<JsonNode> getAllReferences(@Nonnull List<ProductProjection> products) {
            return products.stream().map(this::getAllReferences).flatMap(Collection::stream).collect(Collectors.toList());
        }

        @Nonnull
        private List<JsonNode> getAllReferences(@Nonnull ProductProjection product) {
            List allVariants = product.getAllVariants();
            return this.getAttributeReferences(allVariants);
        }

        @Nonnull
        private List<JsonNode> getAttributeReferences(@Nonnull List<ProductVariant> variants) {
            return variants.stream().map(ProductVariant::getAttributes).flatMap(Collection::stream).map(AttributeUtils::replaceAttributeValueWithJsonAndReturnValue).map(AttributeUtils::getAttributeReferences).flatMap(Collection::stream).collect(Collectors.toList());
        }

        private void replaceReferences(@Nonnull List<JsonNode> allAttributeReferences) {
            allAttributeReferences.forEach(reference -> {
                String id = reference.get("id").asText();
                String key = this.referenceIdToKeyCache.get(id);
                ((ObjectNode)reference).put("id", key);
            });
        }

        @Nonnull
        CompletableFuture<Void> getIdToKeys(@Nonnull List<JsonNode> allAttributeReferences) {
            Set<JsonNode> nonCachedReferences = this.getNonCachedReferences(allAttributeReferences);
            Map<GraphQlQueryResource, Set<String>> map = this.buildMapOfRequestTypeToReferencedIds(nonCachedReferences);
            Set<String> nonCachedCustomObjectIds = map.remove((Object)GraphQlQueryResource.CUSTOM_OBJECTS);
            if (map.values().isEmpty() || map.values().stream().allMatch(referencedIdsSet -> referencedIdsSet.isEmpty())) {
                return this.fetchCustomObjectKeys(nonCachedCustomObjectIds);
            }
            List<GraphQLRequest> collectedRequests = map.keySet().stream().map(resource -> {
                List<List<String>> chunk = ChunkUtils.chunk((Collection)map.get(resource), 300);
                return this.createGraphQLRequests(chunk, (GraphQlQueryResource)((Object)resource));
            }).flatMap(Collection::stream).collect(Collectors.toList());
            return ((CompletableFuture)ChunkUtils.executeChunks(this.getCtpClient(), collectedRequests).thenAccept(this::cacheResourceReferenceKeys)).thenCompose(ignored -> this.fetchCustomObjectKeys(nonCachedCustomObjectIds));
        }

        @Nonnull
        private CompletableFuture<Void> fetchCustomObjectKeys(@Nullable Set<String> nonCachedCustomObjectIds) {
            if (nonCachedCustomObjectIds == null || nonCachedCustomObjectIds.isEmpty()) {
                return CompletableFuture.completedFuture(null);
            }
            List<List<String>> chunkedIds = ChunkUtils.chunk(nonCachedCustomObjectIds, 300);
            List chunkedRequests = chunkedIds.stream().map(ids -> this.getCtpClient().customObjects().get().withWhere((Object)"id in :ids").withPredicateVar("ids", (Collection)ids).withLimit((Object)300).withWithTotal((Object)false)).collect(Collectors.toList());
            return ChunkUtils.executeChunks(chunkedRequests).thenAccept(chunk -> chunk.forEach(response -> {
                CustomObjectPagedQueryResponse responseBody = (CustomObjectPagedQueryResponse)response.getBody();
                responseBody.getResults().forEach(customObject -> this.referenceIdToKeyCache.add(customObject.getId(), CustomObjectCompositeIdentifier.of(customObject).toString()));
            }));
        }
    }
}

