/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.product.Attribute;
import com.commercetools.api.models.product.ProductSetAttributeActionBuilder;
import com.commercetools.api.models.product.ProductSetAttributeInAllVariantsActionBuilder;
import com.commercetools.api.models.product.ProductUpdateAction;
import com.commercetools.sync.commons.exceptions.BuildUpdateActionException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.products.AttributeMetaData;
import com.fasterxml.jackson.databind.JsonNode;
import io.vrap.rmf.base.client.utils.json.JsonUtils;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ProductVariantAttributeUpdateActionUtils {
    public static final String ATTRIBUTE_NOT_IN_ATTRIBUTE_METADATA = "Cannot find the attribute with the name '%s' in the supplied attribute metadata.";

    @Nonnull
    public static Optional<ProductUpdateAction> buildProductVariantAttributeUpdateAction(long variantId, @Nullable Attribute oldProductVariantAttribute, @Nonnull Attribute newProductVariantAttribute, @Nonnull Map<String, AttributeMetaData> attributesMetaData) throws BuildUpdateActionException {
        String newProductVariantAttributeName = newProductVariantAttribute.getName();
        Object newProductVariantAttributeValue = newProductVariantAttribute.getValue();
        Object oldProductVariantAttributeValue = oldProductVariantAttribute != null ? oldProductVariantAttribute.getValue() : null;
        JsonNode newAttributeValueAsJson = JsonUtils.toJsonNode((Object)newProductVariantAttributeValue);
        JsonNode oldAttributeValueAsJson = JsonUtils.toJsonNode((Object)oldProductVariantAttributeValue);
        AttributeMetaData attributeMetaData = attributesMetaData.get(newProductVariantAttributeName);
        if (attributeMetaData == null) {
            String errorMessage = String.format(ATTRIBUTE_NOT_IN_ATTRIBUTE_METADATA, newProductVariantAttributeName);
            throw new BuildUpdateActionException(errorMessage);
        }
        return attributeMetaData.isSameForAll() ? CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeValueAsJson, newAttributeValueAsJson, () -> ProductSetAttributeInAllVariantsActionBuilder.of().value(newProductVariantAttributeValue).name(newProductVariantAttributeName).staged(Boolean.valueOf(true)).build()) : CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeValueAsJson, newAttributeValueAsJson, () -> ProductSetAttributeActionBuilder.of().variantId(Long.valueOf(variantId)).value(newProductVariantAttributeValue).name(newProductVariantAttributeName).staged(Boolean.valueOf(true)).build());
    }

    private ProductVariantAttributeUpdateActionUtils() {
    }
}

