/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.products.utils;

import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.sync.commons.utils.CollectionUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UnorderedCollectionSyncUtils {
    @Nonnull
    public static <T extends ResourceUpdateAction<T>, S, U, V> List<T> buildRemoveUpdateActions(@Nonnull List<U> oldResources, @Nullable List<V> newDrafts, @Nonnull Function<U, S> oldResourceKeyMapper, @Nonnull Function<V, S> draftKeyMapper, @Nonnull Function<U, T> removeUpdateActionMapper) {
        Map<S, U> oldResourcesMap = CollectionUtils.collectionToMap(oldResources, oldResourceKeyMapper);
        oldResourcesMap.remove(null);
        HashMap<S, U> resourcesToRemove = new HashMap<S, U>(oldResourcesMap);
        CollectionUtils.emptyIfNull(newDrafts).stream().filter(Objects::nonNull).map(draftKeyMapper).filter(Objects::nonNull).forEach(resourcesToRemove::remove);
        return resourcesToRemove.values().stream().map(removeUpdateActionMapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private UnorderedCollectionSyncUtils() {
    }
}

