/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.producttypes.utils;

import com.commercetools.api.models.product_type.AttributeConstraintEnum;
import com.commercetools.api.models.product_type.AttributeConstraintEnumDraft;
import com.commercetools.api.models.product_type.AttributeDefinition;
import com.commercetools.api.models.product_type.AttributeDefinitionDraft;
import com.commercetools.api.models.product_type.AttributeEnumType;
import com.commercetools.api.models.product_type.AttributeLocalizedEnumType;
import com.commercetools.api.models.product_type.AttributeSetType;
import com.commercetools.api.models.product_type.AttributeType;
import com.commercetools.api.models.product_type.ProductTypeChangeAttributeConstraintActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeInputHintActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeIsSearchableActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeChangeLabelActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeSetInputTipActionBuilder;
import com.commercetools.api.models.product_type.ProductTypeUpdateAction;
import com.commercetools.api.models.product_type.TextInputHint;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.producttypes.utils.LocalizedEnumValueUpdateActionUtils;
import com.commercetools.sync.producttypes.utils.PlainEnumValueUpdateActionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

final class AttributeDefinitionUpdateActionUtils {
    @Nonnull
    static List<ProductTypeUpdateAction> buildActions(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinitionDraft) throws UnsupportedOperationException {
        List<ProductTypeUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(AttributeDefinitionUpdateActionUtils.buildChangeLabelUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildSetInputTipUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeIsSearchableUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeInputHintUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft), AttributeDefinitionUpdateActionUtils.buildChangeAttributeConstraintUpdateAction(oldAttributeDefinition, newAttributeDefinitionDraft));
        updateActions.addAll(AttributeDefinitionUpdateActionUtils.buildEnumUpdateActions(oldAttributeDefinition, newAttributeDefinitionDraft));
        return updateActions;
    }

    @Nonnull
    static List<ProductTypeUpdateAction> buildEnumUpdateActions(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinitionDraft) {
        AttributeType oldAttributeType = oldAttributeDefinition.getType();
        AttributeType newAttributeType = newAttributeDefinitionDraft.getType();
        AttributeEnumType oldEnumAttributeType = AttributeDefinitionUpdateActionUtils.getAttributeEnumType(oldAttributeType);
        AttributeEnumType newEnumAttributeType = AttributeDefinitionUpdateActionUtils.getAttributeEnumType(newAttributeType);
        if (oldEnumAttributeType != null && newEnumAttributeType != null) {
            return PlainEnumValueUpdateActionUtils.buildEnumValuesUpdateActions(oldAttributeDefinition.getName(), oldEnumAttributeType.getValues(), newEnumAttributeType.getValues());
        }
        AttributeLocalizedEnumType oldLocalizedEnumAttributeType = AttributeDefinitionUpdateActionUtils.getLocalizedEnumAttributeType(oldAttributeType);
        AttributeLocalizedEnumType newLocalizedEnumAttributeType = AttributeDefinitionUpdateActionUtils.getLocalizedEnumAttributeType(newAttributeType);
        if (oldLocalizedEnumAttributeType != null && newLocalizedEnumAttributeType != null) {
            return LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValuesUpdateActions(oldAttributeDefinition.getName(), oldLocalizedEnumAttributeType.getValues(), newLocalizedEnumAttributeType.getValues());
        }
        return Collections.emptyList();
    }

    private static AttributeEnumType getAttributeEnumType(@Nonnull AttributeType attributeType) {
        AttributeSetType setFieldType;
        AttributeType subType;
        if (attributeType instanceof AttributeEnumType) {
            return (AttributeEnumType)attributeType;
        }
        if (attributeType instanceof AttributeSetType && (subType = (setFieldType = (AttributeSetType)attributeType).getElementType()) instanceof AttributeEnumType) {
            return (AttributeEnumType)subType;
        }
        return null;
    }

    private static AttributeLocalizedEnumType getLocalizedEnumAttributeType(@Nonnull AttributeType attributeType) {
        AttributeSetType setFieldType;
        AttributeType subType;
        if (attributeType instanceof AttributeLocalizedEnumType) {
            return (AttributeLocalizedEnumType)attributeType;
        }
        if (attributeType instanceof AttributeSetType && (subType = (setFieldType = (AttributeSetType)attributeType).getElementType()) instanceof AttributeLocalizedEnumType) {
            return (AttributeLocalizedEnumType)subType;
        }
        return null;
    }

    @Nonnull
    static Optional<ProductTypeUpdateAction> buildChangeLabelUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getLabel(), newAttributeDefinition.getLabel(), () -> ProductTypeChangeLabelActionBuilder.of().attributeName(oldAttributeDefinition.getName()).label(newAttributeDefinition.getLabel()).build());
    }

    @Nonnull
    static Optional<ProductTypeUpdateAction> buildSetInputTipUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getInputTip(), newAttributeDefinition.getInputTip(), () -> ProductTypeSetInputTipActionBuilder.of().attributeName(oldAttributeDefinition.getName()).inputTip(newAttributeDefinition.getInputTip()).build());
    }

    @Nonnull
    static Optional<ProductTypeUpdateAction> buildChangeIsSearchableUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        Boolean searchable = Optional.ofNullable(newAttributeDefinition.getIsSearchable()).orElse(true);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getIsSearchable(), searchable, () -> ProductTypeChangeIsSearchableActionBuilder.of().attributeName(oldAttributeDefinition.getName()).isSearchable(searchable).build());
    }

    @Nonnull
    static Optional<ProductTypeUpdateAction> buildChangeInputHintUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) {
        TextInputHint inputHint = Optional.ofNullable(newAttributeDefinition.getInputHint()).orElse(TextInputHint.SINGLE_LINE);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeDefinition.getInputHint(), inputHint, () -> ProductTypeChangeInputHintActionBuilder.of().attributeName(oldAttributeDefinition.getName()).newValue(inputHint).build());
    }

    @Nonnull
    static Optional<ProductTypeUpdateAction> buildChangeAttributeConstraintUpdateAction(@Nonnull AttributeDefinition oldAttributeDefinition, @Nonnull AttributeDefinitionDraft newAttributeDefinition) throws UnsupportedOperationException {
        AttributeConstraintEnum newAttributeConstraint = newAttributeDefinition.getAttributeConstraint();
        AttributeConstraintEnum oldAttributeConstraint = oldAttributeDefinition.getAttributeConstraint();
        if (newAttributeConstraint != null && !newAttributeConstraint.equals(oldAttributeConstraint) && !AttributeConstraintEnum.NONE.equals(newAttributeConstraint)) {
            throw new UnsupportedOperationException(String.format("Invalid AttributeConstraint update to %s. Only following updates are allowed: SameForAll to None and Unique to None.", newAttributeConstraint.name()));
        }
        if (AttributeConstraintEnum.NONE.equals(oldAttributeConstraint) && newAttributeConstraint == null) {
            return Optional.empty();
        }
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldAttributeConstraint, newAttributeConstraint, () -> ProductTypeChangeAttributeConstraintActionBuilder.of().attributeName(oldAttributeDefinition.getName()).newValue(AttributeConstraintEnumDraft.NONE).build());
    }

    private AttributeDefinitionUpdateActionUtils() {
    }
}

