/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.services.impl;

import com.commercetools.api.client.ByProjectKeyCartDiscountsGet;
import com.commercetools.api.client.ByProjectKeyCartDiscountsKeyByKeyGet;
import com.commercetools.api.client.ByProjectKeyCartDiscountsPost;
import com.commercetools.api.models.cart_discount.CartDiscount;
import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.api.models.cart_discount.CartDiscountPagedQueryResponse;
import com.commercetools.api.models.cart_discount.CartDiscountUpdateAction;
import com.commercetools.api.models.cart_discount.CartDiscountUpdateBuilder;
import com.commercetools.api.predicates.query.cart_discount.CartDiscountQueryBuilderDsl;
import com.commercetools.sync.cartdiscounts.CartDiscountSyncOptions;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.services.CartDiscountService;
import com.commercetools.sync.services.impl.BaseServiceWithKey;
import io.vrap.rmf.base.client.ApiHttpResponse;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CartDiscountServiceImpl
extends BaseServiceWithKey<CartDiscountSyncOptions, CartDiscount, CartDiscountDraft, ByProjectKeyCartDiscountsGet, CartDiscountPagedQueryResponse, ByProjectKeyCartDiscountsKeyByKeyGet, CartDiscount, CartDiscountQueryBuilderDsl, ByProjectKeyCartDiscountsPost>
implements CartDiscountService {
    public CartDiscountServiceImpl(@Nonnull CartDiscountSyncOptions syncOptions) {
        super(syncOptions);
    }

    @Override
    @Nonnull
    public CompletionStage<Set<CartDiscount>> fetchMatchingCartDiscountsByKeys(@Nonnull Set<String> keys) {
        return this.fetchMatchingResources(keys, keysNotCached -> ((CartDiscountSyncOptions)this.syncOptions).getCtpClient().cartDiscounts().get().withWhere((Object)"key in :keys").withPredicateVar("keys", (Collection)keysNotCached));
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CartDiscount>> fetchCartDiscount(@Nullable String key) {
        ByProjectKeyCartDiscountsKeyByKeyGet byProjectKeyCartDiscountsKeyByKeyGet = ((CartDiscountSyncOptions)this.syncOptions).getCtpClient().cartDiscounts().withKey(key).get();
        return super.fetchResource(key, byProjectKeyCartDiscountsKeyByKeyGet);
    }

    @Override
    @Nonnull
    public CompletionStage<Optional<CartDiscount>> createCartDiscount(@Nonnull CartDiscountDraft cartDiscountDraft) {
        return super.createResource(cartDiscountDraft, CartDiscountDraft::getKey, CartDiscount::getId, Function.identity(), () -> ((CartDiscountSyncOptions)this.syncOptions).getCtpClient().cartDiscounts().post(cartDiscountDraft));
    }

    @Override
    @Nonnull
    public CompletionStage<CartDiscount> updateCartDiscount(@Nonnull CartDiscount cartDiscount, @Nonnull List<CartDiscountUpdateAction> updateActions) {
        List<List<CartDiscountUpdateAction>> actionBatches = SyncUtils.batchElements(updateActions, 500);
        CompletionStage<Object> resultStage = CompletableFuture.completedFuture(new ApiHttpResponse(200, null, (Object)cartDiscount));
        for (List<CartDiscountUpdateAction> batch : actionBatches) {
            resultStage = resultStage.thenApply(ApiHttpResponse::getBody).thenCompose(updatedCartDiscount -> ((CartDiscountSyncOptions)this.syncOptions).getCtpClient().cartDiscounts().withId(updatedCartDiscount.getId()).post(CartDiscountUpdateBuilder.of().actions(batch).version(updatedCartDiscount.getVersion()).build()).execute());
        }
        return resultStage.thenApply(ApiHttpResponse::getBody);
    }
}

