/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.shoppinglists.utils;

import com.commercetools.api.models.shopping_list.ShoppingList;
import com.commercetools.api.models.shopping_list.ShoppingListDraft;
import com.commercetools.api.models.shopping_list.ShoppingListUpdateAction;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.shoppinglists.ShoppingListSyncOptions;
import com.commercetools.sync.shoppinglists.models.ShoppingListCustomTypeAdapter;
import com.commercetools.sync.shoppinglists.utils.LineItemUpdateActionUtils;
import com.commercetools.sync.shoppinglists.utils.ShoppingListCustomActionBuilder;
import com.commercetools.sync.shoppinglists.utils.ShoppingListUpdateActionUtils;
import com.commercetools.sync.shoppinglists.utils.TextLineItemUpdateActionUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class ShoppingListSyncUtils {
    private static final ShoppingListCustomActionBuilder shoppingListCustomActionBuilder = ShoppingListCustomActionBuilder.of();

    @Nonnull
    public static List<ShoppingListUpdateAction> buildActions(@Nonnull ShoppingList oldShoppingList, @Nonnull ShoppingListDraft newShoppingList, @Nonnull ShoppingListSyncOptions syncOptions) {
        List<ShoppingListUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(ShoppingListUpdateActionUtils.buildSetSlugUpdateAction(oldShoppingList, newShoppingList), ShoppingListUpdateActionUtils.buildChangeNameUpdateAction(oldShoppingList, newShoppingList), ShoppingListUpdateActionUtils.buildSetDescriptionUpdateAction(oldShoppingList, newShoppingList), ShoppingListUpdateActionUtils.buildSetAnonymousIdUpdateAction(oldShoppingList, newShoppingList), ShoppingListUpdateActionUtils.buildSetCustomerUpdateAction(oldShoppingList, newShoppingList), ShoppingListUpdateActionUtils.buildSetDeleteDaysAfterLastModificationUpdateAction(oldShoppingList, newShoppingList));
        updateActions.addAll(CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(ShoppingListCustomTypeAdapter.of(oldShoppingList), () -> ((ShoppingListDraft)newShoppingList).getCustom(), shoppingListCustomActionBuilder, syncOptions));
        updateActions.addAll(LineItemUpdateActionUtils.buildLineItemsUpdateActions(oldShoppingList, newShoppingList, syncOptions));
        updateActions.addAll(TextLineItemUpdateActionUtils.buildTextLineItemsUpdateActions(oldShoppingList, newShoppingList, syncOptions));
        return updateActions;
    }

    private ShoppingListSyncUtils() {
    }
}

