/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.states.utils;

import com.commercetools.api.models.state.State;
import com.commercetools.api.models.state.StateDraft;
import com.commercetools.api.models.state.StateUpdateAction;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.states.utils.StateUpdateActionUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class StateSyncUtils {
    private StateSyncUtils() {
    }

    @Nonnull
    public static List<StateUpdateAction> buildActions(@Nonnull State oldState, @Nonnull StateDraft newState) {
        List<StateUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(StateUpdateActionUtils.buildChangeTypeAction(oldState, newState), StateUpdateActionUtils.buildSetNameAction(oldState, newState), StateUpdateActionUtils.buildSetDescriptionAction(oldState, newState), StateUpdateActionUtils.buildChangeInitialAction(oldState, newState));
        updateActions.addAll(StateUpdateActionUtils.buildRolesUpdateActions(oldState, newState));
        StateUpdateActionUtils.buildSetTransitionsAction(oldState, newState).ifPresent(updateActions::add);
        return updateActions;
    }
}

