/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.taxcategories.utils;

import com.commercetools.api.models.tax_category.TaxCategoryAddTaxRateActionBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryRemoveTaxRateActionBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryReplaceTaxRateActionBuilder;
import com.commercetools.api.models.tax_category.TaxCategoryUpdateAction;
import com.commercetools.api.models.tax_category.TaxRate;
import com.commercetools.api.models.tax_category.TaxRateDraft;
import com.commercetools.api.models.tax_category.TaxRateDraftBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class TaxRatesUpdateActionUtils {
    private TaxRatesUpdateActionUtils() {
    }

    @Nonnull
    static List<TaxCategoryUpdateAction> buildTaxRatesUpdateActions(@Nonnull List<TaxRate> oldTaxRates, List<TaxRateDraft> newTaxRatesDrafts) {
        if (newTaxRatesDrafts != null && !newTaxRatesDrafts.isEmpty()) {
            return TaxRatesUpdateActionUtils.buildUpdateActions(oldTaxRates, newTaxRatesDrafts.stream().filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return oldTaxRates.stream().map(TaxRate::getId).filter(Objects::nonNull).map(id -> TaxCategoryRemoveTaxRateActionBuilder.of().taxRateId(id).build()).collect(Collectors.toList());
    }

    @Nonnull
    private static List<TaxCategoryUpdateAction> buildUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRatesDrafts) {
        ArrayList<TaxRateDraft> newTaxRateDraftsCopy = new ArrayList<TaxRateDraft>(newTaxRatesDrafts);
        List<TaxCategoryUpdateAction> updateActions = TaxRatesUpdateActionUtils.buildRemoveOrReplaceTaxRateUpdateActions(oldTaxRates, newTaxRateDraftsCopy);
        updateActions.addAll(TaxRatesUpdateActionUtils.buildAddTaxRateUpdateActions(oldTaxRates, newTaxRateDraftsCopy));
        return updateActions;
    }

    @Nonnull
    private static List<TaxCategoryUpdateAction> buildRemoveOrReplaceTaxRateUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRatesDrafts) {
        return oldTaxRates.stream().map(oldTaxRate -> newTaxRatesDrafts.stream().filter(newTaxRateDraft -> Objects.equals(oldTaxRate.getCountry(), newTaxRateDraft.getCountry()) && Objects.equals(oldTaxRate.getState(), newTaxRateDraft.getState())).findFirst().map(matchedTaxRateDraft -> {
            if (!TaxRatesUpdateActionUtils.hasSameFields(oldTaxRate, matchedTaxRateDraft)) {
                newTaxRatesDrafts.remove(matchedTaxRateDraft);
                return Collections.singletonList(TaxCategoryReplaceTaxRateActionBuilder.of().taxRateId(oldTaxRate.getId()).taxRate(matchedTaxRateDraft).build());
            }
            return new ArrayList();
        }).orElseGet(() -> Collections.singletonList(TaxCategoryRemoveTaxRateActionBuilder.of().taxRateId(oldTaxRate.getId()).build()))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private static List<TaxCategoryUpdateAction> buildAddTaxRateUpdateActions(@Nonnull List<TaxRate> oldTaxRates, @Nonnull List<TaxRateDraft> newTaxRateDrafts) {
        Map<String, TaxRate> taxRateDraftMap = oldTaxRates.stream().collect(Collectors.toMap(taxRate -> TaxRatesUpdateActionUtils.getTaxRateDraftMapKey(taxRate.getCountry(), taxRate.getState()), taxRateDraft -> taxRateDraft));
        return newTaxRateDrafts.stream().filter(taxRateDraft -> taxRateDraft.getCountry() != null && !taxRateDraftMap.containsKey(TaxRatesUpdateActionUtils.getTaxRateDraftMapKey(taxRateDraft.getCountry(), taxRateDraft.getState()))).map(draft -> TaxCategoryAddTaxRateActionBuilder.of().taxRate(draft).build()).collect(Collectors.toList());
    }

    @Nonnull
    private static String getTaxRateDraftMapKey(@Nonnull String countryCode, String state) {
        return StringUtils.isEmpty((CharSequence)state) ? countryCode : String.format("%s_%s", countryCode, state);
    }

    private static boolean hasSameFields(@Nonnull TaxRate oldTaxRate, @Nonnull TaxRateDraft newTaxRate) {
        if (newTaxRate.getSubRates() == null) {
            newTaxRate.setSubRates(Collections.emptyList());
        }
        TaxRateDraft oldTaxRateAsDraft = TaxRateDraftBuilder.of().amount(oldTaxRate.getAmount()).name(oldTaxRate.getName()).includedInPrice(oldTaxRate.getIncludedInPrice()).country(oldTaxRate.getCountry()).state(oldTaxRate.getState()).subRates(oldTaxRate.getSubRates()).key(oldTaxRate.getKey()).build();
        return oldTaxRateAsDraft.equals(newTaxRate);
    }
}

