/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.api.models.type.CustomFieldEnumType;
import com.commercetools.api.models.type.CustomFieldLocalizedEnumType;
import com.commercetools.api.models.type.CustomFieldSetType;
import com.commercetools.api.models.type.FieldDefinition;
import com.commercetools.api.models.type.FieldType;
import com.commercetools.api.models.type.TypeChangeInputHintActionBuilder;
import com.commercetools.api.models.type.TypeChangeLabelActionBuilder;
import com.commercetools.api.models.type.TypeTextInputHint;
import com.commercetools.api.models.type.TypeUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.types.utils.LocalizedEnumValueUpdateActionUtils;
import com.commercetools.sync.types.utils.PlainEnumValueUpdateActionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;

final class FieldDefinitionUpdateActionUtils {
    @Nonnull
    static List<TypeUpdateAction> buildActions(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        List<TypeUpdateAction> updateActions = OptionalUtils.filterEmptyOptionals(FieldDefinitionUpdateActionUtils.buildChangeLabelUpdateAction(oldFieldDefinition, newFieldDefinition), FieldDefinitionUpdateActionUtils.buildChangeInputHintUpdateAction(oldFieldDefinition, newFieldDefinition));
        updateActions.addAll(FieldDefinitionUpdateActionUtils.buildEnumUpdateActions(oldFieldDefinition, newFieldDefinition));
        return updateActions;
    }

    @Nonnull
    static List<TypeUpdateAction> buildEnumUpdateActions(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        FieldType oldFieldDefinitionType = oldFieldDefinition.getType();
        FieldType newFieldDefinitionType = newFieldDefinition.getType();
        CustomFieldEnumType oldEnumFieldType = FieldDefinitionUpdateActionUtils.getEnumFieldType(oldFieldDefinitionType);
        if (oldEnumFieldType == null) {
            CustomFieldLocalizedEnumType oldLocalizedEnumFieldType = FieldDefinitionUpdateActionUtils.getLocalizedEnumFieldType(oldFieldDefinitionType);
            if (oldLocalizedEnumFieldType == null) {
                return Collections.emptyList();
            }
            CustomFieldLocalizedEnumType newLocalizedEnumFieldType = FieldDefinitionUpdateActionUtils.getLocalizedEnumFieldType(newFieldDefinitionType);
            if (newLocalizedEnumFieldType == null) {
                return Collections.emptyList();
            }
            return LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValuesUpdateActions(oldFieldDefinition.getName(), oldLocalizedEnumFieldType.getValues(), newLocalizedEnumFieldType.getValues());
        }
        CustomFieldEnumType newEnumFieldType = FieldDefinitionUpdateActionUtils.getEnumFieldType(newFieldDefinitionType);
        if (newEnumFieldType == null) {
            return Collections.emptyList();
        }
        return PlainEnumValueUpdateActionUtils.buildEnumValuesUpdateActions(oldFieldDefinition.getName(), oldEnumFieldType.getValues(), newEnumFieldType.getValues());
    }

    private static CustomFieldEnumType getEnumFieldType(@Nonnull FieldType fieldType) {
        CustomFieldSetType setFieldType;
        FieldType subType;
        if (fieldType instanceof CustomFieldEnumType) {
            return (CustomFieldEnumType)fieldType;
        }
        if (fieldType instanceof CustomFieldSetType && (subType = (setFieldType = (CustomFieldSetType)fieldType).getElementType()) instanceof CustomFieldEnumType) {
            return (CustomFieldEnumType)subType;
        }
        return null;
    }

    private static CustomFieldLocalizedEnumType getLocalizedEnumFieldType(@Nonnull FieldType fieldType) {
        CustomFieldSetType setFieldType;
        FieldType subType;
        if (fieldType instanceof CustomFieldLocalizedEnumType) {
            return (CustomFieldLocalizedEnumType)fieldType;
        }
        if (fieldType instanceof CustomFieldSetType && (subType = (setFieldType = (CustomFieldSetType)fieldType).getElementType()) instanceof CustomFieldLocalizedEnumType) {
            return (CustomFieldLocalizedEnumType)subType;
        }
        return null;
    }

    @Nonnull
    static Optional<TypeUpdateAction> buildChangeLabelUpdateAction(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldFieldDefinition.getLabel(), newFieldDefinition.getLabel(), () -> TypeChangeLabelActionBuilder.of().fieldName(oldFieldDefinition.getName()).label(newFieldDefinition.getLabel()).build());
    }

    @Nonnull
    static Optional<TypeUpdateAction> buildChangeInputHintUpdateAction(@Nonnull FieldDefinition oldFieldDefinition, @Nonnull FieldDefinition newFieldDefinition) {
        TypeTextInputHint newFieldInputHint = Optional.ofNullable(newFieldDefinition.getInputHint()).orElse(TypeTextInputHint.SINGLE_LINE);
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldFieldDefinition.getInputHint(), newFieldInputHint, () -> TypeChangeInputHintActionBuilder.of().fieldName(oldFieldDefinition.getName()).inputHint(newFieldInputHint).build());
    }

    private FieldDefinitionUpdateActionUtils() {
    }
}

