/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.types.utils;

import com.commercetools.api.models.type.CustomFieldLocalizedEnumValue;
import com.commercetools.api.models.type.TypeAddLocalizedEnumValueActionBuilder;
import com.commercetools.api.models.type.TypeChangeLocalizedEnumValueLabelActionBuilder;
import com.commercetools.api.models.type.TypeChangeLocalizedEnumValueOrderActionBuilder;
import com.commercetools.api.models.type.TypeUpdateAction;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.commons.utils.EnumValuesUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class LocalizedEnumValueUpdateActionUtils {
    @Nonnull
    static List<TypeUpdateAction> buildLocalizedEnumValuesUpdateActions(@Nonnull String fieldDefinitionName, @Nonnull List<CustomFieldLocalizedEnumValue> oldEnumValues, @Nullable List<CustomFieldLocalizedEnumValue> newEnumValues) {
        return EnumValuesUpdateActionUtils.buildActions(fieldDefinitionName, oldEnumValues, newEnumValues, null, (definitionName, oldEnumValue, newEnumValue) -> LocalizedEnumValueUpdateActionUtils.buildLocalizedEnumValueUpdateActions(fieldDefinitionName, oldEnumValue, newEnumValue), (name, localizedEnumValue) -> TypeAddLocalizedEnumValueActionBuilder.of().fieldName(name).value(localizedEnumValue).build(), null, (name, localizedEnumValues) -> TypeChangeLocalizedEnumValueOrderActionBuilder.of().fieldName(name).keys(localizedEnumValues).build());
    }

    @Nonnull
    public static List<TypeUpdateAction> buildLocalizedEnumValueUpdateActions(@Nonnull String attributeDefinitionName, @Nonnull CustomFieldLocalizedEnumValue oldEnumValue, @Nonnull CustomFieldLocalizedEnumValue newEnumValue) {
        return OptionalUtils.filterEmptyOptionals(LocalizedEnumValueUpdateActionUtils.buildChangeLabelAction(attributeDefinitionName, oldEnumValue, newEnumValue));
    }

    @Nonnull
    private static Optional<TypeUpdateAction> buildChangeLabelAction(@Nonnull String attributeDefinitionName, @Nonnull CustomFieldLocalizedEnumValue oldEnumValue, @Nonnull CustomFieldLocalizedEnumValue newEnumValue) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldEnumValue.getLabel(), newEnumValue.getLabel(), () -> TypeChangeLocalizedEnumValueLabelActionBuilder.of().fieldName(attributeDefinitionName).value(newEnumValue).build());
    }

    private LocalizedEnumValueUpdateActionUtils() {
    }
}

