/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.cartdiscounts.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.cart_discount.CartDiscount;
import com.commercetools.api.models.cart_discount.CartDiscountDraft;
import com.commercetools.sync.cartdiscounts.utils.CartDiscountReferenceResolutionUtils;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CartDiscountTransformUtils {
    @Nonnull
    public static CompletableFuture<List<CartDiscountDraft>> toCartDiscountDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<CartDiscount> cartDiscounts) {
        CartDiscountTransformServiceImpl cartDiscountTransformService = new CartDiscountTransformServiceImpl(client, referenceIdToKeyCache);
        return cartDiscountTransformService.toCartDiscountDrafts(cartDiscounts);
    }

    private static class CartDiscountTransformServiceImpl
    extends BaseTransformServiceImpl {
        public CartDiscountTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<CartDiscountDraft>> toCartDiscountDrafts(@Nonnull List<CartDiscount> cartDiscounts) {
            return this.transformCustomTypeReference(cartDiscounts).thenApply(ignore -> CartDiscountReferenceResolutionUtils.mapToCartDiscountDrafts(cartDiscounts, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<CartDiscount> cartDiscounts) {
            Set<String> setOfTypeIds = cartDiscounts.stream().map(CartDiscount::getCustom).filter(Objects::nonNull).map(customFields -> customFields.getType().getId()).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.TYPES);
        }
    }
}

