/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.helpers;

import com.commercetools.sync.commons.helpers.BaseSyncStatistics;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CategorySyncStatistics
extends BaseSyncStatistics<CategorySyncStatistics> {
    private final ConcurrentHashMap<String, Set<String>> categoryKeysWithMissingParents = new ConcurrentHashMap();

    @Override
    public String getReportMessage() {
        return String.format("Summary: %s categories were processed in total (%s created, %s updated, %s failed to sync and %s categories with a missing parent).", this.getProcessed(), this.getCreated(), this.getUpdated(), this.getFailed(), this.getNumberOfCategoriesWithMissingParents());
    }

    @Override
    protected CategorySyncStatistics getThis() {
        return this;
    }

    public int getNumberOfCategoriesWithMissingParents() {
        return (int)this.categoryKeysWithMissingParents.values().stream().flatMap(Collection::stream).distinct().count();
    }

    public void addMissingDependency(@Nonnull String missingParentCategoryKey, @Nonnull String childKey) {
        this.categoryKeysWithMissingParents.computeIfAbsent(missingParentCategoryKey, ign -> new HashSet()).add(childKey);
    }

    public void removeChildCategoryKeyFromMissingParentsMap(@Nonnull String parentKey, @Nonnull String childKey) {
        this.categoryKeysWithMissingParents.computeIfPresent(parentKey, (key, values) -> {
            values.remove(childKey);
            return values.isEmpty() ? null : values;
        });
    }

    @Nullable
    public Set<String> getChildrenKeys(@Nonnull String parentKey) {
        return this.categoryKeysWithMissingParents.get(parentKey);
    }
}

