/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.categories.utils;

import com.commercetools.api.models.category.Category;
import com.commercetools.api.models.category.CategoryDraft;
import com.commercetools.api.models.category.CategoryDraftBuilder;
import com.commercetools.api.models.category.CategoryResourceIdentifier;
import com.commercetools.api.models.category.CategoryResourceIdentifierBuilder;
import com.commercetools.api.models.common.Reference;
import com.commercetools.sync.commons.utils.AssetReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.CustomTypeReferenceResolutionUtils;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.commons.utils.SyncUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CategoryReferenceResolutionUtils {
    private CategoryReferenceResolutionUtils() {
    }

    @Nonnull
    public static List<CategoryDraft> mapToCategoryDrafts(@Nonnull List<Category> categories, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        return categories.stream().map(category -> CategoryReferenceResolutionUtils.mapToCategoryDraft(category, referenceIdToKeyCache)).collect(Collectors.toList());
    }

    @Nonnull
    private static CategoryDraft mapToCategoryDraft(@Nonnull Category category, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
        CategoryResourceIdentifier resourceIdentifierWithKey = SyncUtils.getResourceIdentifierWithKey((Reference)category.getParent(), referenceIdToKeyCache, (id, key) -> CategoryResourceIdentifierBuilder.of().key(key).id(id).build());
        return CategoryDraftBuilder.of().key(category.getKey()).slug(category.getSlug()).name(category.getName()).description(category.getDescription()).externalId(category.getExternalId()).metaDescription(category.getMetaDescription()).metaKeywords(category.getMetaKeywords()).metaTitle(category.getMetaTitle()).orderHint(category.getOrderHint()).custom(CustomTypeReferenceResolutionUtils.mapToCustomFieldsDraft(category, referenceIdToKeyCache)).assets(AssetReferenceResolutionUtils.mapToAssetDrafts(category.getAssets(), referenceIdToKeyCache)).parent(resourceIdentifierWithKey).build();
    }
}

