/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.ResourceUpdateAction;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.QuadConsumer;
import com.commercetools.sync.commons.utils.TriConsumer;
import com.commercetools.sync.commons.utils.TriFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public abstract class BaseSyncOptionsBuilder<SyncOptionsBuilderT extends BaseSyncOptionsBuilder<SyncOptionsBuilderT, SyncOptionsT, ResourceT, ResourceDraftT, ResourceUpdateActionT>, SyncOptionsT extends BaseSyncOptions<ResourceT, ResourceDraftT, ResourceUpdateActionT>, ResourceT, ResourceDraftT, ResourceUpdateActionT extends ResourceUpdateAction<ResourceUpdateActionT>> {
    protected ProjectApiRoot ctpClient;
    protected QuadConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>, List<ResourceUpdateActionT>> errorCallback;
    protected TriConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>> warningCallback;
    protected int batchSize = 30;
    protected TriFunction<List<ResourceUpdateActionT>, ResourceDraftT, ResourceT, List<ResourceUpdateActionT>> beforeUpdateCallback;
    protected Function<ResourceDraftT, ResourceDraftT> beforeCreateCallback;
    protected long cacheSize = 10000L;

    public SyncOptionsBuilderT errorCallback(@Nonnull QuadConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>, List<ResourceUpdateActionT>> errorCallback) {
        this.errorCallback = errorCallback;
        return this.getThis();
    }

    public SyncOptionsBuilderT warningCallback(@Nonnull TriConsumer<SyncException, Optional<ResourceDraftT>, Optional<ResourceT>> warningCallback) {
        this.warningCallback = warningCallback;
        return this.getThis();
    }

    public SyncOptionsBuilderT batchSize(int batchSize) {
        if (batchSize > 0) {
            this.batchSize = batchSize;
        }
        return this.getThis();
    }

    public SyncOptionsBuilderT cacheSize(long cacheSize) {
        if (cacheSize > 0L) {
            this.cacheSize = cacheSize;
        }
        return this.getThis();
    }

    public SyncOptionsBuilderT beforeUpdateCallback(@Nonnull TriFunction<List<ResourceUpdateActionT>, ResourceDraftT, ResourceT, List<ResourceUpdateActionT>> beforeUpdateCallback) {
        this.beforeUpdateCallback = beforeUpdateCallback;
        return this.getThis();
    }

    public SyncOptionsBuilderT beforeCreateCallback(@Nonnull Function<ResourceDraftT, ResourceDraftT> beforeCreateCallback) {
        this.beforeCreateCallback = beforeCreateCallback;
        return this.getThis();
    }

    protected abstract SyncOptionsT build();

    protected abstract SyncOptionsBuilderT getThis();
}

