/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.custom_object.CustomObject;
import com.commercetools.api.models.graph_ql.GraphQLRequest;
import com.commercetools.api.models.graph_ql.GraphQLRequestBuilder;
import com.commercetools.api.models.graph_ql.GraphQLVariablesMap;
import com.commercetools.api.models.graph_ql.GraphQLVariablesMapBuilder;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.fasterxml.jackson.databind.JsonNode;
import io.vrap.rmf.base.client.ApiHttpResponse;
import io.vrap.rmf.base.client.error.NotFoundException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CleanupUnresolvedReferenceCustomObjects {
    private final ProjectApiRoot ctpClient;
    private final Statistics statistics;
    private int pageSize = 500;
    private Consumer<Throwable> errorCallback;

    private CleanupUnresolvedReferenceCustomObjects(@Nonnull ProjectApiRoot ctpClient) {
        this.ctpClient = ctpClient;
        this.statistics = new Statistics();
    }

    public static CleanupUnresolvedReferenceCustomObjects of(@Nonnull ProjectApiRoot ctpClient) {
        return new CleanupUnresolvedReferenceCustomObjects(ctpClient);
    }

    public CleanupUnresolvedReferenceCustomObjects errorCallback(@Nonnull Consumer<Throwable> errorCallback) {
        this.errorCallback = errorCallback;
        return this;
    }

    private void applyErrorCallback(@Nonnull Throwable exception) {
        if (this.errorCallback != null) {
            this.errorCallback.accept(exception);
        }
    }

    public CleanupUnresolvedReferenceCustomObjects pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public CompletableFuture<Statistics> cleanup(int deleteDaysAfterLastModification) {
        return CompletableFuture.allOf(this.cleanupUnresolvedProductReferences(deleteDaysAfterLastModification), this.cleanupUnresolvedParentCategoryReferences(deleteDaysAfterLastModification), this.cleanupUnresolvedStateReferences(deleteDaysAfterLastModification)).thenApply(ignoredResult -> this.statistics);
    }

    private CompletableFuture<Void> cleanup(@Nonnull String containerName, int deleteDaysAfterLastModification) {
        GraphQlQueryAll graphQlQueryAll = new GraphQlQueryAll(this.ctpClient, this.buildGraphQlRequest(containerName, deleteDaysAfterLastModification), this.pageSize);
        return graphQlQueryAll.run(customObjectsToRemove -> this.deleteCustomObjects(containerName, (Map<String, String>)customObjectsToRemove)).toCompletableFuture();
    }

    private CompletableFuture<Void> cleanupUnresolvedProductReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedReferencesService.productDrafts", deleteDaysAfterLastModification);
    }

    private CompletableFuture<Void> cleanupUnresolvedParentCategoryReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedReferencesService.categoryDrafts", deleteDaysAfterLastModification);
    }

    private CompletableFuture<Void> cleanupUnresolvedStateReferences(int deleteDaysAfterLastModification) {
        return this.cleanup("commercetools-sync-java.UnresolvedTransitionsService.stateDrafts", deleteDaysAfterLastModification);
    }

    private GraphQLRequest buildGraphQlRequest(@Nonnull String containerName, int deleteDaysAfterLastModification) {
        Instant lastModifiedAt = Instant.now().minus(deleteDaysAfterLastModification, ChronoUnit.DAYS);
        String query = String.format("query fetchKeys($where: String, $limit: Int, $sort: [String!], $container: String!) {%n  %s(container: $container, limit: $limit, where: $where, sort: $sort) {%n    results {%n      id,%n      key%n    }%n  }%n}", GraphQlQueryResource.CUSTOM_OBJECTS.getName());
        GraphQLVariablesMap graphQLVariablesMap = GraphQLVariablesMapBuilder.of().addValue("container", (Object)containerName).addValue("where", (Object)String.format("lastModifiedAt < \"%s\"", lastModifiedAt)).build();
        return GraphQLRequestBuilder.of().query(query).variables(graphQLVariablesMap).build();
    }

    private void deleteCustomObjects(@Nonnull String containerName, @Nonnull Map<String, String> resourceIdKeyMap) {
        CompletableFuture.allOf((CompletableFuture[])resourceIdKeyMap.values().stream().map(resourceKey -> this.executeDeletion(containerName, (String)resourceKey)).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new)).join();
    }

    private CompletionStage<Optional<CustomObject>> executeDeletion(@Nonnull String containerName, @Nonnull String resourceKey) {
        return this.ctpClient.customObjects().withContainerAndKey(containerName, resourceKey).delete().execute().handle(this::handleDeleteCallback);
    }

    private Optional<CustomObject> handleDeleteCallback(@Nonnull ApiHttpResponse<CustomObject> resource, @Nullable Throwable throwable) {
        if (throwable == null) {
            this.statistics.totalDeleted.incrementAndGet();
            return Optional.of((CustomObject)resource.getBody());
        }
        if (throwable instanceof NotFoundException) {
            return Optional.empty();
        }
        this.applyErrorCallback(throwable);
        this.statistics.totalFailed.incrementAndGet();
        return Optional.empty();
    }

    private static class GraphQlQueryAll {
        private final ProjectApiRoot client;
        private final GraphQLRequest graphqlRequest;
        private final long pageSize;
        private Consumer<Map<String, String>> pageConsumer;

        public GraphQlQueryAll(@Nonnull ProjectApiRoot client, @Nonnull GraphQLRequest graphqlRequest, long pageSize) {
            this.client = client;
            this.graphqlRequest = graphqlRequest;
            GraphQLVariablesMap graphQLVariablesMap = this.graphqlRequest.getVariables();
            graphQLVariablesMap.setValue("limit", (Object)pageSize);
            graphQLVariablesMap.setValue("sort", List.of("id asc"));
            this.graphqlRequest.setVariables(graphQLVariablesMap);
            this.pageSize = pageSize;
        }

        @Nonnull
        CompletionStage<Void> run(@Nonnull Consumer<Map<String, String>> pageConsumer) {
            this.pageConsumer = pageConsumer;
            CompletableFuture firstPage = this.client.graphql().post(this.graphqlRequest).execute(JsonNode.class);
            return this.queryNextPages(firstPage);
        }

        @Nonnull
        private CompletionStage<Void> queryNextPages(@Nonnull CompletableFuture<ApiHttpResponse<JsonNode>> currentPageStage) {
            return currentPageStage.thenCompose(currentPage -> currentPage != null && currentPage.getBody() != null ? this.queryNextPages(this.processPageAndGetNext((JsonNode)currentPage.getBody())) : CompletableFuture.completedFuture(null));
        }

        @Nonnull
        private CompletableFuture<ApiHttpResponse<JsonNode>> processPageAndGetNext(@Nonnull JsonNode jsonNode) {
            HashMap<String, String> idKeyMap = new HashMap<String, String>();
            Iterator elements = jsonNode.get("data").get(GraphQlQueryResource.CUSTOM_OBJECTS.getName()).get("results").elements();
            while (elements.hasNext()) {
                JsonNode entry = (JsonNode)elements.next();
                idKeyMap.put(entry.get("id").asText(), entry.get("key").asText());
            }
            if (!idKeyMap.isEmpty()) {
                this.consumePageElements(idKeyMap);
                return this.getNextPageStage(idKeyMap);
            }
            return CompletableFuture.completedFuture(new ApiHttpResponse(200, null, null));
        }

        private void consumePageElements(@Nonnull Map<String, String> idKeyElements) {
            this.pageConsumer.accept(idKeyElements);
        }

        @Nonnull
        private CompletableFuture<ApiHttpResponse<JsonNode>> getNextPageStage(@Nonnull Map<String, String> idKeyMap) {
            if ((long)idKeyMap.size() == this.pageSize) {
                String lastElementId = "";
                Iterator<String> iterator = idKeyMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String id;
                    lastElementId = id = iterator.next();
                }
                if (StringUtils.isNotBlank((CharSequence)lastElementId)) {
                    String pagingPredicate = String.format("id > \"%s\"", lastElementId);
                    GraphQLVariablesMap graphQLVariablesMap = this.graphqlRequest.getVariables();
                    String predicate = Optional.ofNullable(graphQLVariablesMap.values().get("where")).map(where -> {
                        String queryPredicate = String.valueOf(where);
                        return StringUtils.isBlank((CharSequence)queryPredicate) ? pagingPredicate : String.format("%s and %s", queryPredicate, pagingPredicate);
                    }).orElseGet(() -> pagingPredicate);
                    graphQLVariablesMap.setValue("where", (Object)predicate);
                    this.graphqlRequest.setVariables(graphQLVariablesMap);
                }
                return this.client.graphql().post(this.graphqlRequest).execute(JsonNode.class);
            }
            return CompletableFuture.completedFuture(new ApiHttpResponse(200, null, null));
        }
    }

    public static class Statistics {
        final AtomicInteger totalDeleted = new AtomicInteger();
        final AtomicInteger totalFailed = new AtomicInteger();

        private Statistics() {
        }

        public int getTotalDeleted() {
            return this.totalDeleted.get();
        }

        public int getTotalFailed() {
            return this.totalFailed.get();
        }

        public String getReportMessage() {
            return String.format("Summary: %s custom objects were deleted in total (%s failed to delete).", this.getTotalDeleted(), this.getTotalFailed());
        }
    }
}

