/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.exceptions;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

final class ExceptionUtils {
    @Nonnull
    static String buildMessage(@Nonnull String message, @Nonnull Set<Throwable> causes, int causesTabbingDepth) {
        String causesString = ExceptionUtils.asMessage(causes, causesTabbingDepth);
        return StringUtils.isNotBlank((CharSequence)causesString) ? String.format("%s %s", message, causesString) : message;
    }

    @Nonnull
    private static String asMessage(@Nonnull Set<Throwable> causes, int tabbingDepth) {
        String tabs = ExceptionUtils.buildTabs(tabbingDepth);
        List<String> causesMessages = causes.stream().map(Throwable::getMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return !causesMessages.isEmpty() ? ExceptionUtils.buildCausesMessage(tabs, causesMessages) : "";
    }

    @Nonnull
    private static String buildCausesMessage(@Nonnull String tabs, @Nonnull List<String> causesMessages) {
        return String.format("Causes:%n%s%s", tabs, ExceptionUtils.joinCauses(tabs, causesMessages));
    }

    @Nonnull
    private static String joinCauses(@Nonnull String tabs, @Nonnull List<String> causesMessages) {
        return String.join((CharSequence)String.format("%n%s", tabs), causesMessages);
    }

    @Nonnull
    private static String buildTabs(int numberOfTabs) {
        return IntStream.range(0, numberOfTabs).mapToObj(index -> "\t").collect(Collectors.joining());
    }

    private ExceptionUtils() {
    }
}

