/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.helpers;

import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.sync.commons.BaseSyncOptions;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import io.vrap.rmf.base.client.Draft;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseReferenceResolver<ResourceDraftT extends Draft<ResourceDraftT>, SyncOptionsT extends BaseSyncOptions> {
    public static final String BLANK_KEY_VALUE_ON_RESOURCE_IDENTIFIER = "The value of the 'key' field of the Resource Identifier is blank (null/empty). Expecting the key of the referenced resource.";
    public static final String BLANK_ID_VALUE_ON_REFERENCE = "The value of the 'id' field of the Reference is blank (null/empty). Expecting the key of the referenced resource.";
    public static final String SELF_REFERENCING_ID_PLACE_HOLDER = "SELF_REFERENCE_ID";
    protected SyncOptionsT options;

    protected BaseReferenceResolver(@Nonnull SyncOptionsT options) {
        this.options = options;
    }

    public abstract CompletionStage<ResourceDraftT> resolveReferences(@Nonnull ResourceDraftT var1);

    @Nonnull
    protected static <T> String getIdFromReference(@Nonnull Reference reference) throws ReferenceResolutionException {
        String id = reference.getId();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new ReferenceResolutionException(BLANK_ID_VALUE_ON_REFERENCE);
        }
        return id;
    }

    @Nonnull
    protected static String getKeyFromResourceIdentifier(@Nonnull ResourceIdentifier resourceIdentifier) throws ReferenceResolutionException {
        String key = resourceIdentifier.getKey();
        if (StringUtils.isBlank((CharSequence)key) || "KEY_IS_NOT_SET".equals(key)) {
            throw new ReferenceResolutionException(BLANK_KEY_VALUE_ON_RESOURCE_IDENTIFIER);
        }
        return key;
    }
}

