/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.commons.utils;

import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class SyncUtils {
    private static final String UUID_REGEX = "[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}";

    public static <T> List<List<T>> batchElements(@Nonnull List<T> elements, int batchSize) {
        ArrayList<List<T>> batches = new ArrayList<List<T>>();
        for (int i = 0; i < elements.size() && batchSize > 0; i += batchSize) {
            batches.add(elements.subList(i, Math.min(i + batchSize, elements.size())));
        }
        return batches;
    }

    @Nullable
    public static <ResourceIdentifierT extends ResourceIdentifier> ResourceIdentifierT getResourceIdentifierWithKey(@Nullable Reference reference, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull BiFunction<String, String, ResourceIdentifierT> toResourceIdentifierWithIdAndKey) {
        return (ResourceIdentifierT)((ResourceIdentifier)Optional.ofNullable(reference).map(ref -> {
            String id = ref.getId();
            return SyncUtils.getResourceIdentifierWithKey(id, referenceIdToKeyCache.get(id), toResourceIdentifierWithIdAndKey);
        }).orElse(null));
    }

    private static <ResourceIdentifierT extends ResourceIdentifier> ResourceIdentifierT getResourceIdentifierWithKey(@Nonnull String id, @Nullable String key, BiFunction<String, String, ResourceIdentifierT> toResourceIdentifier) {
        if (!StringUtils.isBlank((CharSequence)key)) {
            return (ResourceIdentifierT)((ResourceIdentifier)toResourceIdentifier.apply(null, key));
        }
        return (ResourceIdentifierT)((ResourceIdentifier)toResourceIdentifier.apply(id, null));
    }

    public static boolean isUuid(@Nonnull String id) {
        Pattern regexPattern = Pattern.compile(UUID_REGEX);
        return regexPattern.matcher(id).matches();
    }

    private SyncUtils() {
    }
}

