/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers;

import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerUpdateAction;
import com.commercetools.sync.commons.BaseSync;
import com.commercetools.sync.commons.utils.SyncUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.helpers.CustomerBatchValidator;
import com.commercetools.sync.customers.helpers.CustomerReferenceResolver;
import com.commercetools.sync.customers.helpers.CustomerSyncStatistics;
import com.commercetools.sync.customers.utils.CustomerSyncUtils;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.CustomerService;
import com.commercetools.sync.services.TypeService;
import com.commercetools.sync.services.impl.CustomerGroupServiceImpl;
import com.commercetools.sync.services.impl.CustomerServiceImpl;
import com.commercetools.sync.services.impl.TypeServiceImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CustomerSync
extends BaseSync<Customer, CustomerDraft, CustomerUpdateAction, CustomerSyncStatistics, CustomerSyncOptions> {
    private static final String CTP_CUSTOMER_FETCH_FAILED = "Failed to fetch existing customers with keys: '%s'.";
    private static final String FAILED_TO_PROCESS = "Failed to process the CustomerDraft with key:'%s'. Reason: %s";
    private static final String CTP_CUSTOMER_UPDATE_FAILED = "Failed to update customer with key: '%s'. Reason: %s";
    private final CustomerService customerService;
    private final CustomerReferenceResolver referenceResolver;
    private final CustomerBatchValidator batchValidator;

    public CustomerSync(@Nonnull CustomerSyncOptions customerSyncOptions) {
        this(customerSyncOptions, new CustomerServiceImpl(customerSyncOptions), new TypeServiceImpl(customerSyncOptions), new CustomerGroupServiceImpl(customerSyncOptions));
    }

    protected CustomerSync(@Nonnull CustomerSyncOptions customerSyncOptions, @Nonnull CustomerService customerService, @Nonnull TypeService typeService, @Nonnull CustomerGroupService customerGroupService) {
        super(new CustomerSyncStatistics(), customerSyncOptions);
        this.customerService = customerService;
        this.referenceResolver = new CustomerReferenceResolver((CustomerSyncOptions)this.getSyncOptions(), typeService, customerGroupService);
        this.batchValidator = new CustomerBatchValidator((CustomerSyncOptions)this.getSyncOptions(), (CustomerSyncStatistics)this.getStatistics());
    }

    @Override
    protected CompletionStage<CustomerSyncStatistics> process(@Nonnull List<CustomerDraft> customerDrafts) {
        List batches = SyncUtils.batchElements(customerDrafts, ((CustomerSyncOptions)this.syncOptions).getBatchSize());
        return this.syncBatches(batches, CompletableFuture.completedFuture((CustomerSyncStatistics)this.statistics));
    }

    @Override
    protected CompletionStage<CustomerSyncStatistics> processBatch(@Nonnull List<CustomerDraft> batch) {
        ImmutablePair<Set<CustomerDraft>, CustomerBatchValidator.ReferencedKeys> result = this.batchValidator.validateAndCollectReferencedKeys(batch);
        Set validCustomerDrafts = (Set)result.getLeft();
        if (validCustomerDrafts.isEmpty()) {
            ((CustomerSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return CompletableFuture.completedFuture((CustomerSyncStatistics)this.statistics);
        }
        return ((CompletableFuture)((CompletableFuture)this.referenceResolver.populateKeyToIdCachesForReferencedKeys((CustomerBatchValidator.ReferencedKeys)result.getRight()).handle(ImmutablePair::new)).thenCompose(cachingResponse -> {
            Throwable cachingException = (Throwable)cachingResponse.getValue();
            if (cachingException != null) {
                this.handleError("Failed to build a cache of keys to ids.", cachingException, null, null, Collections.emptyList(), validCustomerDrafts.size());
                return CompletableFuture.completedFuture(null);
            }
            Set<String> validCustomerKeys = validCustomerDrafts.stream().map(CustomerDraft::getKey).collect(Collectors.toSet());
            return this.customerService.fetchMatchingCustomersByKeys(validCustomerKeys).handle(ImmutablePair::new).thenCompose(fetchResponse -> {
                Set fetchedCustomers = (Set)fetchResponse.getKey();
                Throwable exception = (Throwable)fetchResponse.getValue();
                if (exception != null) {
                    String errorMessage = String.format(CTP_CUSTOMER_FETCH_FAILED, validCustomerKeys);
                    this.handleError(errorMessage, exception, null, null, Collections.emptyList(), validCustomerKeys.size());
                    return CompletableFuture.completedFuture(null);
                }
                return this.syncBatch(fetchedCustomers, validCustomerDrafts);
            });
        })).thenApply(ignoredResult -> {
            ((CustomerSyncStatistics)this.statistics).incrementProcessed(batch.size());
            return (CustomerSyncStatistics)this.statistics;
        });
    }

    @Nonnull
    private CompletionStage<Void> syncBatch(@Nonnull Set<Customer> oldCustomers, @Nonnull Set<CustomerDraft> newCustomerDrafts) {
        Map oldCustomerMap = oldCustomers.stream().collect(Collectors.toMap(Customer::getKey, Function.identity()));
        return CompletableFuture.allOf((CompletableFuture[])newCustomerDrafts.stream().map(customerDraft -> this.referenceResolver.resolveReferences((CustomerDraft)customerDraft).thenCompose(resolvedCustomerDraft -> this.syncDraft(oldCustomerMap, (CustomerDraft)resolvedCustomerDraft)).exceptionally(completionException -> {
            String errorMessage = String.format(FAILED_TO_PROCESS, customerDraft.getKey(), completionException.getMessage());
            this.handleError(errorMessage, (Throwable)completionException, null, customerDraft, Collections.emptyList(), 1);
            return null;
        })).map(CompletionStage::toCompletableFuture).toArray(CompletableFuture[]::new));
    }

    @Nonnull
    private CompletionStage<Void> syncDraft(@Nonnull Map<String, Customer> oldCustomerMap, @Nonnull CustomerDraft newCustomerDraft) {
        Customer oldCustomer = oldCustomerMap.get(newCustomerDraft.getKey());
        return Optional.ofNullable(oldCustomer).map(customer -> this.buildActionsAndUpdate(oldCustomer, newCustomerDraft)).orElseGet(() -> this.applyCallbackAndCreate(newCustomerDraft));
    }

    @Nonnull
    private CompletionStage<Void> buildActionsAndUpdate(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomerDraft) {
        List<CustomerUpdateAction> updateActions = CustomerSyncUtils.buildActions(oldCustomer, newCustomerDraft, (CustomerSyncOptions)this.syncOptions);
        List<CustomerUpdateAction> updateActionsAfterCallback = ((CustomerSyncOptions)this.syncOptions).applyBeforeUpdateCallback(updateActions, newCustomerDraft, oldCustomer);
        if (!updateActionsAfterCallback.isEmpty()) {
            return this.updateCustomer(oldCustomer, newCustomerDraft, updateActionsAfterCallback);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Nonnull
    private CompletionStage<Void> updateCustomer(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomerDraft, @Nonnull List<CustomerUpdateAction> updateActionsAfterCallback) {
        return this.customerService.updateCustomer(oldCustomer, updateActionsAfterCallback).handle(ImmutablePair::of).thenCompose(updateResponse -> {
            Throwable exception = (Throwable)updateResponse.getValue();
            if (exception != null) {
                return CustomerSync.executeSupplierIfConcurrentModificationException(exception, () -> this.fetchAndUpdate(oldCustomer, newCustomerDraft), () -> {
                    String errorMessage = String.format(CTP_CUSTOMER_UPDATE_FAILED, newCustomerDraft.getKey(), exception.getMessage());
                    this.handleError(errorMessage, exception, oldCustomer, newCustomerDraft, updateActionsAfterCallback, 1);
                    return CompletableFuture.completedFuture(null);
                });
            }
            ((CustomerSyncStatistics)this.statistics).incrementUpdated();
            return CompletableFuture.completedFuture(null);
        });
    }

    @Nonnull
    private CompletionStage<Void> fetchAndUpdate(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomerDraft) {
        String customerKey = oldCustomer.getKey();
        return this.customerService.fetchCustomerByKey(customerKey).handle(ImmutablePair::of).thenCompose(fetchResponse -> {
            Optional fetchedCustomerOptional = (Optional)fetchResponse.getKey();
            Throwable exception = (Throwable)fetchResponse.getValue();
            if (exception != null) {
                String errorMessage = String.format(CTP_CUSTOMER_UPDATE_FAILED, customerKey, "Failed to fetch from CTP while retrying after concurrency modification.");
                this.handleError(errorMessage, exception, oldCustomer, newCustomerDraft, Collections.emptyList(), 1);
                return CompletableFuture.completedFuture(null);
            }
            return fetchedCustomerOptional.map(fetchedCustomer -> this.buildActionsAndUpdate((Customer)fetchedCustomer, newCustomerDraft)).orElseGet(() -> {
                String errorMessage = String.format(CTP_CUSTOMER_UPDATE_FAILED, customerKey, "Not found when attempting to fetch while retrying after concurrency modification.");
                this.handleError(errorMessage, null, oldCustomer, newCustomerDraft, Collections.emptyList(), 1);
                return CompletableFuture.completedFuture(null);
            });
        });
    }

    @Nonnull
    private CompletionStage<Void> applyCallbackAndCreate(@Nonnull CustomerDraft customerDraft) {
        return ((CustomerSyncOptions)this.syncOptions).applyBeforeCreateCallback(customerDraft).map(draft -> this.customerService.createCustomer((CustomerDraft)draft).thenAccept(customerOptional -> {
            if (customerOptional.isPresent()) {
                ((CustomerSyncStatistics)this.statistics).incrementCreated();
            } else {
                ((CustomerSyncStatistics)this.statistics).incrementFailed();
            }
        })).orElseGet(() -> CompletableFuture.completedFuture(null));
    }
}

