/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.helpers;

import com.commercetools.api.models.common.ResourceIdentifier;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerDraftBuilder;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifier;
import com.commercetools.api.models.customer_group.CustomerGroupResourceIdentifierBuilder;
import com.commercetools.api.models.store.StoreResourceIdentifier;
import com.commercetools.api.models.store.StoreResourceIdentifierBuilder;
import com.commercetools.sync.commons.exceptions.ReferenceResolutionException;
import com.commercetools.sync.commons.helpers.CustomReferenceResolver;
import com.commercetools.sync.customers.CustomerSyncOptions;
import com.commercetools.sync.customers.helpers.CustomerBatchValidator;
import com.commercetools.sync.services.CustomerGroupService;
import com.commercetools.sync.services.TypeService;
import io.vrap.rmf.base.client.utils.CompletableFutureUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CustomerReferenceResolver
extends CustomReferenceResolver<CustomerDraft, CustomerDraftBuilder, CustomerSyncOptions> {
    public static final String FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE = "Failed to resolve customer group resource identifier on CustomerDraft with key:'%s'. Reason: %s";
    public static final String FAILED_TO_RESOLVE_STORE_REFERENCE = "Failed to resolve store resource identifier on CustomerDraft with key:'%s'. Reason: %s";
    public static final String FAILED_TO_RESOLVE_CUSTOM_TYPE = "Failed to resolve custom type reference on CustomerDraft with key:'%s'.";
    public static final String CUSTOMER_GROUP_DOES_NOT_EXIST = "CustomerGroup with key '%s' doesn't exist.";
    private final TypeService typeService;
    private final CustomerGroupService customerGroupService;

    public CustomerReferenceResolver(@Nonnull CustomerSyncOptions options, @Nonnull TypeService typeService, @Nonnull CustomerGroupService customerGroupService) {
        super(options, typeService);
        this.typeService = typeService;
        this.customerGroupService = customerGroupService;
    }

    @Override
    @Nonnull
    public CompletionStage<CustomerDraft> resolveReferences(@Nonnull CustomerDraft customerDraft) {
        return this.resolveCustomTypeReference(CustomerDraftBuilder.of((CustomerDraft)customerDraft)).thenCompose(this::resolveCustomerGroupReference).thenCompose(this::resolveStoreReferences).thenApply(CustomerDraftBuilder::build);
    }

    @Override
    protected CompletionStage<CustomerDraftBuilder> resolveCustomTypeReference(@Nonnull CustomerDraftBuilder draftBuilder) {
        return this.resolveCustomTypeReference(draftBuilder, CustomerDraftBuilder::getCustom, CustomerDraftBuilder::custom, String.format(FAILED_TO_RESOLVE_CUSTOM_TYPE, draftBuilder.getKey()));
    }

    @Nonnull
    public CompletionStage<CustomerDraftBuilder> resolveCustomerGroupReference(@Nonnull CustomerDraftBuilder draftBuilder) {
        CustomerGroupResourceIdentifier customerGroupResourceIdentifier = draftBuilder.getCustomerGroup();
        if (customerGroupResourceIdentifier != null && customerGroupResourceIdentifier.getId() == null) {
            String customerGroupKey;
            try {
                customerGroupKey = CustomerReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)customerGroupResourceIdentifier);
            }
            catch (ReferenceResolutionException referenceResolutionException) {
                return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
            }
            return this.fetchAndResolveCustomerGroupReference(draftBuilder, customerGroupKey);
        }
        return CompletableFuture.completedFuture(draftBuilder);
    }

    @Nonnull
    private CompletionStage<CustomerDraftBuilder> fetchAndResolveCustomerGroupReference(@Nonnull CustomerDraftBuilder draftBuilder, @Nonnull String customerGroupKey) {
        return this.customerGroupService.fetchCachedCustomerGroupId(customerGroupKey).thenCompose(resolvedCustomerGroupIdOptional -> resolvedCustomerGroupIdOptional.map(resolvedCustomerGroupId -> CompletableFuture.completedFuture(draftBuilder.customerGroup(CustomerGroupResourceIdentifierBuilder.of().id(resolvedCustomerGroupId).build()))).orElseGet(() -> {
            String errorMessage = String.format(CUSTOMER_GROUP_DOES_NOT_EXIST, customerGroupKey);
            return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_CUSTOMER_GROUP_REFERENCE, draftBuilder.getKey(), errorMessage)));
        }));
    }

    @Nonnull
    public CompletionStage<CustomerDraftBuilder> resolveStoreReferences(@Nonnull CustomerDraftBuilder draftBuilder) {
        List storeResourceIdentifiers = draftBuilder.getStores();
        if (storeResourceIdentifiers == null || storeResourceIdentifiers.isEmpty()) {
            return CompletableFuture.completedFuture(draftBuilder);
        }
        ArrayList<StoreResourceIdentifier> resolvedReferences = new ArrayList<StoreResourceIdentifier>();
        for (StoreResourceIdentifier storeResourceIdentifier : storeResourceIdentifiers) {
            if (storeResourceIdentifier == null) continue;
            if (storeResourceIdentifier.getId() == null) {
                try {
                    String storeKey = CustomerReferenceResolver.getKeyFromResourceIdentifier((ResourceIdentifier)storeResourceIdentifier);
                    resolvedReferences.add(StoreResourceIdentifierBuilder.of().key(storeKey).build());
                    continue;
                }
                catch (ReferenceResolutionException referenceResolutionException) {
                    return CompletableFutureUtils.exceptionallyCompletedFuture((Throwable)new ReferenceResolutionException(String.format(FAILED_TO_RESOLVE_STORE_REFERENCE, draftBuilder.getKey(), referenceResolutionException.getMessage())));
                }
            }
            resolvedReferences.add(StoreResourceIdentifierBuilder.of().id(storeResourceIdentifier.getId()).build());
        }
        return CompletableFuture.completedFuture(draftBuilder.stores(resolvedReferences));
    }

    @Nonnull
    public CompletableFuture<List<Map<String, String>>> populateKeyToIdCachesForReferencedKeys(@Nonnull CustomerBatchValidator.ReferencedKeys referencedKeys) {
        Set<String> customerGroupKeys;
        ArrayList<CompletionStage<Map<String, String>>> futures = new ArrayList<CompletionStage<Map<String, String>>>();
        Set<String> typeKeys = referencedKeys.getTypeKeys();
        if (!typeKeys.isEmpty()) {
            futures.add(this.typeService.cacheKeysToIds(typeKeys));
        }
        if (!(customerGroupKeys = referencedKeys.getCustomerGroupKeys()).isEmpty()) {
            futures.add(this.customerGroupService.cacheKeysToIds(customerGroupKeys));
        }
        return com.commercetools.sync.commons.utils.CompletableFutureUtils.collectionOfFuturesToFutureOfCollection(futures, Collectors.toList());
    }
}

