/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.api.client.ProjectApiRoot;
import com.commercetools.api.models.common.Reference;
import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.type.CustomFields;
import com.commercetools.sync.commons.models.GraphQlQueryResource;
import com.commercetools.sync.commons.utils.ReferenceIdToKeyCache;
import com.commercetools.sync.customers.utils.CustomerReferenceResolutionUtils;
import com.commercetools.sync.services.impl.BaseTransformServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class CustomerTransformUtils {
    @Nonnull
    public static CompletableFuture<List<CustomerDraft>> toCustomerDrafts(@Nonnull ProjectApiRoot client, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache, @Nonnull List<Customer> customers) {
        CustomerTransformServiceImpl customerTransformService = new CustomerTransformServiceImpl(client, referenceIdToKeyCache);
        return customerTransformService.toCustomerDrafts(customers);
    }

    private static class CustomerTransformServiceImpl
    extends BaseTransformServiceImpl {
        public CustomerTransformServiceImpl(@Nonnull ProjectApiRoot ctpClient, @Nonnull ReferenceIdToKeyCache referenceIdToKeyCache) {
            super(ctpClient, referenceIdToKeyCache);
        }

        @Nonnull
        public CompletableFuture<List<CustomerDraft>> toCustomerDrafts(@Nonnull List<Customer> customers) {
            ArrayList<CompletableFuture<Void>> transformReferencesToRunParallel = new ArrayList<CompletableFuture<Void>>();
            transformReferencesToRunParallel.add(this.transformCustomTypeReference(customers));
            transformReferencesToRunParallel.add(this.transformCustomerGroupReference(customers));
            return CompletableFuture.allOf((CompletableFuture[])transformReferencesToRunParallel.stream().toArray(CompletableFuture[]::new)).thenApply(ignore -> CustomerReferenceResolutionUtils.mapToCustomerDrafts(customers, this.referenceIdToKeyCache));
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomTypeReference(@Nonnull List<Customer> customers) {
            Set<String> setOfTypeIds = customers.stream().map(Customer::getCustom).filter(Objects::nonNull).map(CustomFields::getType).map(Reference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(setOfTypeIds, GraphQlQueryResource.TYPES);
        }

        @Nonnull
        private CompletableFuture<Void> transformCustomerGroupReference(@Nonnull List<Customer> customers) {
            Set<String> customerGroupIds = customers.stream().map(Customer::getCustomerGroup).filter(Objects::nonNull).map(Reference::getId).collect(Collectors.toSet());
            return this.fetchAndFillReferenceIdToKeyCache(customerGroupIds, GraphQlQueryResource.CUSTOMER_GROUPS);
        }
    }
}

