/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customers.utils;

import com.commercetools.api.models.common.Address;
import com.commercetools.api.models.common.BaseAddress;
import com.commercetools.api.models.customer.Customer;
import com.commercetools.api.models.customer.CustomerAddAddressActionBuilder;
import com.commercetools.api.models.customer.CustomerAddBillingAddressIdActionBuilder;
import com.commercetools.api.models.customer.CustomerAddShippingAddressIdActionBuilder;
import com.commercetools.api.models.customer.CustomerAddStoreActionBuilder;
import com.commercetools.api.models.customer.CustomerChangeAddressActionBuilder;
import com.commercetools.api.models.customer.CustomerChangeEmailActionBuilder;
import com.commercetools.api.models.customer.CustomerDraft;
import com.commercetools.api.models.customer.CustomerRemoveAddressAction;
import com.commercetools.api.models.customer.CustomerRemoveAddressActionBuilder;
import com.commercetools.api.models.customer.CustomerRemoveBillingAddressIdAction;
import com.commercetools.api.models.customer.CustomerRemoveBillingAddressIdActionBuilder;
import com.commercetools.api.models.customer.CustomerRemoveShippingAddressIdAction;
import com.commercetools.api.models.customer.CustomerRemoveShippingAddressIdActionBuilder;
import com.commercetools.api.models.customer.CustomerRemoveStoreActionBuilder;
import com.commercetools.api.models.customer.CustomerSetCompanyNameActionBuilder;
import com.commercetools.api.models.customer.CustomerSetCustomerGroupActionBuilder;
import com.commercetools.api.models.customer.CustomerSetCustomerNumberActionBuilder;
import com.commercetools.api.models.customer.CustomerSetDateOfBirthActionBuilder;
import com.commercetools.api.models.customer.CustomerSetDefaultBillingAddressActionBuilder;
import com.commercetools.api.models.customer.CustomerSetDefaultShippingAddressActionBuilder;
import com.commercetools.api.models.customer.CustomerSetExternalIdActionBuilder;
import com.commercetools.api.models.customer.CustomerSetFirstNameActionBuilder;
import com.commercetools.api.models.customer.CustomerSetLastNameActionBuilder;
import com.commercetools.api.models.customer.CustomerSetLocaleActionBuilder;
import com.commercetools.api.models.customer.CustomerSetMiddleNameActionBuilder;
import com.commercetools.api.models.customer.CustomerSetSalutationActionBuilder;
import com.commercetools.api.models.customer.CustomerSetStoresActionBuilder;
import com.commercetools.api.models.customer.CustomerSetTitleActionBuilder;
import com.commercetools.api.models.customer.CustomerSetVatIdActionBuilder;
import com.commercetools.api.models.customer.CustomerUpdateAction;
import com.commercetools.api.models.store.StoreKeyReference;
import com.commercetools.api.models.store.StoreResourceIdentifier;
import com.commercetools.api.models.store.StoreResourceIdentifierBuilder;
import com.commercetools.sync.commons.exceptions.SyncException;
import com.commercetools.sync.commons.utils.CommonTypeUpdateActionUtils;
import com.commercetools.sync.customers.CustomerSyncOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class CustomerUpdateActionUtils {
    public static final String CUSTOMER_NUMBER_EXISTS_WARNING = "Customer with key: \"%s\" has already a customer number: \"%s\", once it's set it cannot be changed. Hereby, the update action is not created.";

    private CustomerUpdateActionUtils() {
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildChangeEmailUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getEmail(), newCustomer.getEmail(), () -> CustomerChangeEmailActionBuilder.of().email(newCustomer.getEmail()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetFirstNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getFirstName(), newCustomer.getFirstName(), () -> CustomerSetFirstNameActionBuilder.of().firstName(newCustomer.getFirstName()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetLastNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getLastName(), newCustomer.getLastName(), () -> CustomerSetLastNameActionBuilder.of().lastName(newCustomer.getLastName()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetMiddleNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getMiddleName(), newCustomer.getMiddleName(), () -> CustomerSetMiddleNameActionBuilder.of().middleName(newCustomer.getMiddleName()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetTitleUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getTitle(), newCustomer.getTitle(), () -> CustomerSetTitleActionBuilder.of().title(newCustomer.getTitle()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetSalutationUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getSalutation(), newCustomer.getSalutation(), () -> CustomerSetSalutationActionBuilder.of().salutation(newCustomer.getSalutation()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetCustomerNumberUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer, @Nonnull CustomerSyncOptions syncOptions) {
        Optional<CustomerUpdateAction> setCustomerNumberAction = CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getCustomerNumber(), newCustomer.getCustomerNumber(), () -> CustomerSetCustomerNumberActionBuilder.of().customerNumber(newCustomer.getCustomerNumber()).build());
        if (setCustomerNumberAction.isPresent() && !StringUtils.isBlank((CharSequence)oldCustomer.getCustomerNumber())) {
            syncOptions.applyWarningCallback(new SyncException(String.format(CUSTOMER_NUMBER_EXISTS_WARNING, oldCustomer.getKey(), oldCustomer.getCustomerNumber())), oldCustomer, newCustomer);
            return Optional.empty();
        }
        return setCustomerNumberAction;
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetExternalIdUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getExternalId(), newCustomer.getExternalId(), () -> CustomerSetExternalIdActionBuilder.of().externalId(newCustomer.getExternalId()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetCompanyNameUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getCompanyName(), newCustomer.getCompanyName(), () -> CustomerSetCompanyNameActionBuilder.of().companyName(newCustomer.getCompanyName()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetDateOfBirthUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getDateOfBirth(), newCustomer.getDateOfBirth(), () -> CustomerSetDateOfBirthActionBuilder.of().dateOfBirth(newCustomer.getDateOfBirth()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetVatIdUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getVatId(), newCustomer.getVatId(), () -> CustomerSetVatIdActionBuilder.of().vatId(newCustomer.getVatId()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetLocaleUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateAction(oldCustomer.getLocale(), newCustomer.getLocale(), () -> CustomerSetLocaleActionBuilder.of().locale(newCustomer.getLocale()).build());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetCustomerGroupUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        return CommonTypeUpdateActionUtils.buildUpdateActionForReferences(oldCustomer.getCustomerGroup(), newCustomer.getCustomerGroup(), () -> CustomerSetCustomerGroupActionBuilder.of().customerGroup(newCustomer.getCustomerGroup()).build());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildStoreUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        List oldStores = oldCustomer.getStores();
        List newStores = newCustomer.getStores();
        return CustomerUpdateActionUtils.buildSetStoreUpdateAction(oldStores, newStores).map(Collections::singletonList).orElseGet(() -> CustomerUpdateActionUtils.prepareStoreActions(oldStores, newStores));
    }

    private static List<CustomerUpdateAction> prepareStoreActions(@Nullable List<StoreKeyReference> oldStores, @Nullable List<StoreResourceIdentifier> newStores) {
        if (oldStores != null && newStores != null) {
            List<CustomerUpdateAction> removeStoreUpdateActions = CustomerUpdateActionUtils.buildRemoveStoreUpdateActions(oldStores, newStores);
            List<CustomerUpdateAction> addStoreUpdateActions = CustomerUpdateActionUtils.buildAddStoreUpdateActions(oldStores, newStores);
            if (!removeStoreUpdateActions.isEmpty() && !addStoreUpdateActions.isEmpty()) {
                return CustomerUpdateActionUtils.buildSetStoreUpdateAction(newStores).map(Collections::singletonList).orElseGet(Collections::emptyList);
            }
            return removeStoreUpdateActions.isEmpty() ? addStoreUpdateActions : removeStoreUpdateActions;
        }
        return Collections.emptyList();
    }

    @Nonnull
    private static Optional<CustomerUpdateAction> buildSetStoreUpdateAction(@Nullable List<StoreKeyReference> oldStores, @Nullable List<StoreResourceIdentifier> newStores) {
        if (oldStores != null && !oldStores.isEmpty()) {
            if (newStores == null || newStores.isEmpty()) {
                return Optional.of(CustomerSetStoresActionBuilder.of().stores(Collections.emptyList()).build());
            }
        } else if (newStores != null && !newStores.isEmpty()) {
            return CustomerUpdateActionUtils.buildSetStoreUpdateAction(newStores);
        }
        return Optional.empty();
    }

    private static Optional<CustomerUpdateAction> buildSetStoreUpdateAction(@Nonnull List<StoreResourceIdentifier> newStores) {
        List stores = newStores.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!stores.isEmpty()) {
            return Optional.of(CustomerSetStoresActionBuilder.of().stores(stores).build());
        }
        return Optional.empty();
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildRemoveStoreUpdateActions(@Nonnull List<StoreKeyReference> oldStores, @Nonnull List<StoreResourceIdentifier> newStores) {
        Map newStoreKeyToStoreMap = newStores.stream().filter(Objects::nonNull).filter(storeResourceIdentifier -> storeResourceIdentifier.getKey() != null).collect(Collectors.toMap(StoreResourceIdentifier::getKey, Function.identity()));
        return oldStores.stream().filter(Objects::nonNull).filter(storeKeyReference -> !newStoreKeyToStoreMap.containsKey(storeKeyReference.getKey())).map(storeKeyReference -> CustomerRemoveStoreActionBuilder.of().store(StoreResourceIdentifierBuilder.of().key(storeKeyReference.getKey()).build()).build()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildAddStoreUpdateActions(@Nonnull List<StoreKeyReference> oldStores, @Nonnull List<StoreResourceIdentifier> newStores) {
        Map oldStoreKeyToStoreMap = oldStores.stream().filter(Objects::nonNull).collect(Collectors.toMap(StoreKeyReference::getKey, Function.identity()));
        return newStores.stream().filter(Objects::nonNull).filter(storeResourceIdentifier -> !oldStoreKeyToStoreMap.containsKey(storeResourceIdentifier.getKey())).map(storeResourceIdentifier -> CustomerAddStoreActionBuilder.of().store(storeResourceIdentifier).build()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildAllAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        ArrayList<CustomerUpdateAction> addressActions = new ArrayList<CustomerUpdateAction>();
        List<CustomerUpdateAction> removeAddressActions = CustomerUpdateActionUtils.buildRemoveAddressUpdateActions(oldCustomer, newCustomer);
        addressActions.addAll(removeAddressActions);
        addressActions.addAll(CustomerUpdateActionUtils.buildChangeAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.buildAddAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.collectAndFilterRemoveShippingAndBillingActions(removeAddressActions, oldCustomer, newCustomer));
        CustomerUpdateActionUtils.buildSetDefaultShippingAddressUpdateAction(oldCustomer, newCustomer).ifPresent(addressActions::add);
        CustomerUpdateActionUtils.buildSetDefaultBillingAddressUpdateAction(oldCustomer, newCustomer).ifPresent(addressActions::add);
        addressActions.addAll(CustomerUpdateActionUtils.buildAddShippingAddressUpdateActions(oldCustomer, newCustomer));
        addressActions.addAll(CustomerUpdateActionUtils.buildAddBillingAddressUpdateActions(oldCustomer, newCustomer));
        return addressActions;
    }

    @Nonnull
    private static List<CustomerUpdateAction> collectAndFilterRemoveShippingAndBillingActions(@Nonnull List<CustomerUpdateAction> removeAddressActions, @Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Set addressIdsToRemove = removeAddressActions.stream().map(customerUpdateAction -> (CustomerRemoveAddressAction)customerUpdateAction).map(CustomerRemoveAddressAction::getAddressId).collect(Collectors.toSet());
        ArrayList<CustomerUpdateAction> removeActions = new ArrayList<CustomerUpdateAction>();
        removeActions.addAll(CustomerUpdateActionUtils.buildRemoveShippingAddressUpdateActions(oldCustomer, newCustomer).stream().map(customerUpdateAction -> (CustomerRemoveShippingAddressIdAction)customerUpdateAction).filter(action -> !addressIdsToRemove.contains(action.getAddressId())).collect(Collectors.toList()));
        removeActions.addAll(CustomerUpdateActionUtils.buildRemoveBillingAddressUpdateActions(oldCustomer, newCustomer).stream().map(customerUpdateAction -> (CustomerRemoveBillingAddressIdAction)customerUpdateAction).filter(action -> !addressIdsToRemove.contains(action.getAddressId())).collect(Collectors.toList()));
        return removeActions;
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildRemoveAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (oldCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return oldCustomer.getAddresses().stream().map(address -> CustomerRemoveAddressActionBuilder.of().addressId(address.getId()).build()).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getAddresses().stream().filter(Objects::nonNull).map(BaseAddress::getKey).filter(key -> !StringUtils.isBlank((CharSequence)key)).collect(Collectors.toSet());
        return oldCustomer.getAddresses().stream().filter(oldAddress -> StringUtils.isBlank((CharSequence)oldAddress.getKey()) || !newAddressKeys.contains(oldAddress.getKey())).map(address -> {
            if (address.getId() != null) {
                return CustomerRemoveAddressActionBuilder.of().addressId(address.getId()).build();
            }
            return CustomerRemoveAddressActionBuilder.of().addressKey(address.getKey()).build();
        }).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildChangeAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(BaseAddress::getKey, Function.identity()));
        return newCustomer.getAddresses().stream().filter(Objects::nonNull).filter(newAddress -> !StringUtils.isBlank((CharSequence)newAddress.getKey())).filter(newAddress -> oldAddressKeyToAddressMap.containsKey(newAddress.getKey())).map(newAddress -> {
            Address oldAddress = (Address)oldAddressKeyToAddressMap.get(newAddress.getKey());
            String oldAddressId = oldAddress.getId();
            String newAddressId = newAddress.getId();
            oldAddress.setId(null);
            newAddress.setId(null);
            if (!newAddress.equals(oldAddress)) {
                oldAddress.setId(oldAddressId);
                newAddress.setId(newAddressId);
                return CustomerChangeAddressActionBuilder.of().addressId(oldAddressId).address(newAddress).build();
            }
            oldAddress.setId(oldAddressId);
            newAddress.setId(newAddressId);
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildAddAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getAddresses() == null || newCustomer.getAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = oldCustomer.getAddresses().stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(BaseAddress::getKey, Function.identity()));
        return newCustomer.getAddresses().stream().filter(Objects::nonNull).filter(newAddress -> !StringUtils.isBlank((CharSequence)newAddress.getKey())).filter(newAddress -> !oldAddressKeyToAddressMap.containsKey(newAddress.getKey())).map(newAddress -> CustomerAddAddressActionBuilder.of().address(newAddress).build()).collect(Collectors.toList());
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetDefaultShippingAddressUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Optional<Address> oldAddress = oldCustomer.getAddresses().stream().filter(address -> address.getId() != null && address.getId().equals(oldCustomer.getDefaultShippingAddressId())).findFirst();
        String newAddressKey = CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), newCustomer.getDefaultShippingAddress());
        if (newAddressKey != null) {
            if (!oldAddress.isPresent() || !Objects.equals(oldAddress.get().getKey(), newAddressKey)) {
                return Optional.of(CustomerSetDefaultShippingAddressActionBuilder.of().addressKey(newAddressKey).build());
            }
        } else if (oldAddress.isPresent()) {
            return Optional.of(CustomerSetDefaultShippingAddressActionBuilder.of().build());
        }
        return Optional.empty();
    }

    @Nonnull
    public static Optional<CustomerUpdateAction> buildSetDefaultBillingAddressUpdateAction(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        Optional<Address> oldAddress = oldCustomer.getAddresses().stream().filter(address -> address.getId() != null && address.getId().equals(oldCustomer.getDefaultBillingAddressId())).findFirst();
        String newAddressKey = CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), newCustomer.getDefaultBillingAddress());
        if (newAddressKey != null) {
            if (!oldAddress.isPresent() || !Objects.equals(oldAddress.get().getKey(), newAddressKey)) {
                return Optional.of(CustomerSetDefaultBillingAddressActionBuilder.of().addressKey(newAddressKey).build());
            }
        } else if (oldAddress.isPresent()) {
            return Optional.of(CustomerSetDefaultBillingAddressActionBuilder.of().build());
        }
        return Optional.empty();
    }

    @Nullable
    private static String getAddressKeyAt(@Nullable List<BaseAddress> addressList, @Nullable Integer index) {
        if (index == null) {
            return null;
        }
        if (addressList == null || index < 0 || index >= addressList.size()) {
            throw new IllegalArgumentException(String.format("Addresses list does not contain an address at the index: %s", index));
        }
        BaseAddress address = addressList.get(index);
        if (address == null) {
            throw new IllegalArgumentException(String.format("Address is null at the index: %s of the addresses list.", index));
        }
        if (StringUtils.isBlank((CharSequence)address.getKey())) {
            throw new IllegalArgumentException(String.format("Address does not have a key at the index: %s of the addresses list.", index));
        }
        return address.getKey();
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildAddShippingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        if (newCustomer.getShippingAddresses() == null || newCustomer.getShippingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = CustomerUpdateActionUtils.getShippingAddresses(oldCustomer).stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(BaseAddress::getKey, Function.identity()));
        Set newAddressKeys = newCustomer.getShippingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return newAddressKeys.stream().filter(newAddressKey -> !oldAddressKeyToAddressMap.containsKey(newAddressKey)).map(key -> CustomerAddShippingAddressIdActionBuilder.of().addressKey(key).build()).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Address> getShippingAddresses(@Nonnull Customer oldCustomer) {
        HashSet ids = new HashSet(oldCustomer.getShippingAddressIds());
        return oldCustomer.getAddresses().stream().filter(id -> ids.contains(id.getId())).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Address> getBillingAddresses(@Nonnull Customer oldCustomer) {
        HashSet ids = new HashSet(oldCustomer.getBillingAddressIds());
        return oldCustomer.getAddresses().stream().filter(id -> ids.contains(id.getId())).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildRemoveShippingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        List<Address> shippingAddresses = CustomerUpdateActionUtils.getShippingAddresses(oldCustomer);
        if (shippingAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getShippingAddresses() == null || newCustomer.getShippingAddresses().isEmpty()) {
            return shippingAddresses.stream().map(address -> CustomerRemoveShippingAddressIdActionBuilder.of().addressId(address.getId()).build()).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getShippingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return shippingAddresses.stream().filter(address -> StringUtils.isBlank((CharSequence)address.getKey()) || !newAddressKeys.contains(address.getKey())).map(address -> CustomerRemoveShippingAddressIdActionBuilder.of().addressId(address.getId()).build()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildAddBillingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        List<Address> billingAddresses = CustomerUpdateActionUtils.getBillingAddresses(oldCustomer);
        if (newCustomer.getBillingAddresses() == null || newCustomer.getBillingAddresses().isEmpty()) {
            return Collections.emptyList();
        }
        Map oldAddressKeyToAddressMap = billingAddresses.stream().filter(address -> !StringUtils.isBlank((CharSequence)address.getKey())).collect(Collectors.toMap(BaseAddress::getKey, Function.identity()));
        Set newAddressKeys = newCustomer.getBillingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return newAddressKeys.stream().filter(newAddressKey -> !oldAddressKeyToAddressMap.containsKey(newAddressKey)).map(key -> CustomerAddBillingAddressIdActionBuilder.of().addressKey(key).build()).collect(Collectors.toList());
    }

    @Nonnull
    public static List<CustomerUpdateAction> buildRemoveBillingAddressUpdateActions(@Nonnull Customer oldCustomer, @Nonnull CustomerDraft newCustomer) {
        List<Address> billingAddresses = CustomerUpdateActionUtils.getBillingAddresses(oldCustomer);
        if (billingAddresses.isEmpty()) {
            return Collections.emptyList();
        }
        if (newCustomer.getBillingAddresses() == null || newCustomer.getBillingAddresses().isEmpty()) {
            return billingAddresses.stream().map(address -> CustomerRemoveBillingAddressIdActionBuilder.of().addressId(address.getId()).build()).collect(Collectors.toList());
        }
        Set newAddressKeys = newCustomer.getBillingAddresses().stream().map(index -> CustomerUpdateActionUtils.getAddressKeyAt(newCustomer.getAddresses(), index)).collect(Collectors.toSet());
        return billingAddresses.stream().filter(address -> StringUtils.isBlank((CharSequence)address.getKey()) || !newAddressKeys.contains(address.getKey())).map(address -> CustomerRemoveBillingAddressIdActionBuilder.of().addressId(address.getId()).build()).collect(Collectors.toList());
    }
}

