/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.customobjects.helpers;

import com.commercetools.api.models.custom_object.CustomObjectDraft;
import com.commercetools.sync.commons.helpers.BaseBatchValidator;
import com.commercetools.sync.customobjects.CustomObjectSyncOptions;
import com.commercetools.sync.customobjects.helpers.CustomObjectCompositeIdentifier;
import com.commercetools.sync.customobjects.helpers.CustomObjectSyncStatistics;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CustomObjectBatchValidator
extends BaseBatchValidator<CustomObjectDraft, CustomObjectSyncOptions, CustomObjectSyncStatistics> {
    static final String CUSTOM_OBJECT_DRAFT_IS_NULL = "CustomObjectDraft is null.";

    public CustomObjectBatchValidator(@Nonnull CustomObjectSyncOptions syncOptions, @Nonnull CustomObjectSyncStatistics syncStatistics) {
        super(syncOptions, syncStatistics);
    }

    @Override
    public ImmutablePair<Set<CustomObjectDraft>, Set<CustomObjectCompositeIdentifier>> validateAndCollectReferencedKeys(@Nonnull List<CustomObjectDraft> customObjectDrafts) {
        Set validDrafts = customObjectDrafts.stream().filter(this::isValidCustomObjectDraft).collect(Collectors.toSet());
        Set validIdentifiers = validDrafts.stream().map(CustomObjectCompositeIdentifier::of).collect(Collectors.toSet());
        return ImmutablePair.of(validDrafts, validIdentifiers);
    }

    private boolean isValidCustomObjectDraft(@Nullable CustomObjectDraft customObjectDraft) {
        if (customObjectDraft == null) {
            this.handleError(CUSTOM_OBJECT_DRAFT_IS_NULL);
            return false;
        }
        return true;
    }
}

