/*
 * Decompiled with CFR 0.152.
 */
package com.commercetools.sync.inventories.utils;

import com.commercetools.api.models.inventory.InventoryEntry;
import com.commercetools.api.models.inventory.InventoryEntryDraft;
import com.commercetools.api.models.inventory.InventoryEntryUpdateAction;
import com.commercetools.sync.commons.utils.CustomUpdateActionUtils;
import com.commercetools.sync.commons.utils.OptionalUtils;
import com.commercetools.sync.inventories.InventorySyncOptions;
import com.commercetools.sync.inventories.helpers.InventoryCustomActionBuilder;
import com.commercetools.sync.inventories.models.InventoryEntryCustomTypeAdapter;
import com.commercetools.sync.inventories.models.InventoryEntryDraftCustomTypeAdapter;
import com.commercetools.sync.inventories.utils.InventoryUpdateActionUtils;
import java.util.List;
import javax.annotation.Nonnull;

public final class InventorySyncUtils {
    private static final InventoryCustomActionBuilder inventoryCustomActionBuilder = new InventoryCustomActionBuilder();

    @Nonnull
    public static List<InventoryEntryUpdateAction> buildActions(@Nonnull InventoryEntry oldEntry, @Nonnull InventoryEntryDraft newEntry, @Nonnull InventorySyncOptions syncOptions) {
        List<InventoryEntryUpdateAction> actions = OptionalUtils.filterEmptyOptionals(InventoryUpdateActionUtils.buildChangeQuantityAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetRestockableInDaysAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetExpectedDeliveryAction(oldEntry, newEntry), InventoryUpdateActionUtils.buildSetSupplyChannelAction(oldEntry, newEntry));
        actions.addAll(CustomUpdateActionUtils.buildPrimaryResourceCustomUpdateActions(InventoryEntryCustomTypeAdapter.of(oldEntry), InventoryEntryDraftCustomTypeAdapter.of(newEntry), inventoryCustomActionBuilder, syncOptions));
        return actions;
    }

    private InventorySyncUtils() {
    }
}

